/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations.storage.properties;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.atcplus.autotreechopplus.libs.tinytranslations.MessageStyle;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.Commented;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.StorageEntry;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.StyleStorage;
import org.atcplus.autotreechopplus.libs.tinytranslations.storage.properties.PropertiesUtils;

public class PropertiesStyleStorage
implements StyleStorage {
    private final File file;

    public PropertiesStyleStorage(File file) {
        this.file = file;
    }

    private File file() {
        if (!this.file.exists()) {
            try {
                this.file.getParentFile().mkdirs();
                this.file.createNewFile();
            }
            catch (Throwable t) {
                throw new IllegalStateException("Could not create properties file.", t);
            }
        }
        if (this.file.isDirectory()) {
            throw new IllegalArgumentException("PropertiesStyles requires a properties file as argument");
        }
        if (!this.file.getName().endsWith(".properties")) {
            throw new IllegalArgumentException("PropertiesStyles requires a properties file as argument");
        }
        return this.file;
    }

    @Override
    public void writeStyles(Map<String, MessageStyle> styles) {
        List<StorageEntry> lines = this.readStylesFile(this.file());
        Map<String, MessageStyle> present = this.readStylesFromLines(lines);
        LinkedHashMap<String, MessageStyle> toWrite = new LinkedHashMap<String, MessageStyle>();
        for (Map.Entry<String, MessageStyle> stylePair : styles.entrySet()) {
            if (present.containsKey(stylePair.getKey())) continue;
            toWrite.put(stylePair.getKey(), stylePair.getValue());
        }
        toWrite.forEach((s, style) -> {
            String string;
            String string2 = style.toString();
            if (style instanceof Commented) {
                Commented c = (Commented)((Object)style);
                string = c.comment();
            } else {
                string = null;
            }
            lines.add(new StorageEntry((String)s, string2, string));
        });
        this.writeStyles(lines);
    }

    private void writeStyles(List<StorageEntry> lines) {
        try (FileWriter writer = new FileWriter(this.file, StandardCharsets.UTF_8);){
            PropertiesUtils.write(writer, lines);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, MessageStyle> loadStyles() {
        return this.readStylesFromLines(this.readStylesFile(this.file()));
    }

    private Map<String, MessageStyle> readStylesFromLines(List<StorageEntry> lines) {
        return lines.stream().collect(Collectors.toMap(StorageEntry::key, e -> MessageStyle.messageStyle(e.key(), e.value()), (a, b) -> a, LinkedHashMap::new));
    }

    private List<StorageEntry> readStylesFile(File file) {
        List<StorageEntry> list;
        FileReader r = new FileReader(file, StandardCharsets.UTF_8);
        try {
            list = PropertiesUtils.loadProperties(r);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)r).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                throw new RuntimeException("Error while parsing locale file '" + file.getAbsolutePath() + "'.", t);
            }
        }
        ((Reader)r).close();
        return list;
    }

    private static interface Line {
        public String print();
    }
}

