/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.libs.tinytranslations.util;

import java.util.List;

public class ListSection {
    private int offset;
    private int range;

    private ListSection(int offset, int range) {
        this.offset = offset;
        this.range = range;
    }

    public static ListSection range(int offset, int range) {
        return new ListSection(offset, range);
    }

    public static ListSection paged(int page, int size) {
        return new ListSection(page * size, size);
    }

    public <E> List<E> apply(List<E> list) {
        int max = list.size();
        return list.subList(Integer.max(0, Integer.min(this.offset, max)), Integer.max(0, Integer.min(this.offset + this.range, max)));
    }

    public int getPage() {
        if (this.range == 0) {
            return 0;
        }
        return this.offset / this.range;
    }

    public int getMaxPages(int size) {
        if (this.range == 0) {
            return 1;
        }
        return (int)Math.ceil((double)size / (double)this.range);
    }

    public int getOffset() {
        return this.offset;
    }

    public int getRange() {
        return this.range;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setRange(int range) {
        this.range = range;
    }
}

