/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.atcplus.autotreechopplus.AutoTreeChopPlus;
import org.atcplus.autotreechopplus.Config;
import org.atcplus.autotreechopplus.PlayerConfig;
import org.atcplus.autotreechopplus.hooks.GriefPreventionHook;
import org.atcplus.autotreechopplus.hooks.LandsHook;
import org.atcplus.autotreechopplus.hooks.ResidenceHook;
import org.atcplus.autotreechopplus.hooks.WorldGuardHook;
import org.atcplus.autotreechopplus.utils.EffectUtils;
import org.atcplus.autotreechopplus.utils.PermissionUtils;
import org.atcplus.autotreechopplus.utils.TreeChopUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class LeafRemovalUtils {
    private static final Map<String, Set<Location>> removedLogsPerSession = new HashMap<String, Set<Location>>();
    private static final Set<String> activeLeafRemovalSessions = new HashSet<String>();
    private static final EnumSet<Material> NETHER_FUNGUS_LEAVES = EnumSet.of(Material.NETHER_WART_BLOCK, Material.WARPED_WART_BLOCK, Material.SHROOMLIGHT);
    private static final EnumSet<Material> NETHER_FUNGUS_LOGS = EnumSet.of(Material.CRIMSON_STEM, new Material[]{Material.STRIPPED_CRIMSON_STEM, Material.CRIMSON_HYPHAE, Material.STRIPPED_CRIMSON_HYPHAE, Material.WARPED_STEM, Material.STRIPPED_WARPED_STEM, Material.WARPED_HYPHAE, Material.STRIPPED_WARPED_HYPHAE});

    public static void processLeafRemoval(Block originalLogBlock, Material originalLogType, Player player, AutoTreeChopPlus plugin, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook) {
        if (!config.isLeafRemovalEnabled()) {
            return;
        }
        if (!player.hasPermission("atcplus.leaves")) {
            return;
        }
        String playerKey = player.getUniqueId().toString();
        if (activeLeafRemovalSessions.contains(playerKey)) {
            return;
        }
        String sessionId = playerKey + "_" + System.currentTimeMillis();
        removedLogsPerSession.put(sessionId, new HashSet());
        activeLeafRemovalSessions.add(playerKey);
        boolean netherFungusContext = config.isNetherFungiEnabled() && (LeafRemovalUtils.isNetherFungusLog(originalLogType) || originalLogBlock.getWorld().getEnvironment() == World.Environment.NETHER);
        Runnable leafRemovalTask = () -> {
            HashSet<Location> checkedLeafLocations = new HashSet<Location>();
            HashSet<Location> processingLeafLocations = new HashSet<Location>();
            long delayTicks = Math.max(config.getLeafRemovalDelayTicks(), 60L);
            if (delayTicks > 0L) {
                LeafRemovalUtils.scheduleDelayedLeafRemoval(originalLogBlock, netherFungusContext, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, checkedLeafLocations, processingLeafLocations, sessionId, playerKey);
            } else {
                LeafRemovalUtils.startLeafRemoval(originalLogBlock, netherFungusContext, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, checkedLeafLocations, processingLeafLocations, sessionId, playerKey);
            }
        };
        if (config.isLeafRemovalAsync() && !AutoTreeChopPlus.isFolia()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> Bukkit.getScheduler().runTask((Plugin)plugin, leafRemovalTask));
        } else {
            leafRemovalTask.run();
        }
    }

    public static void trackRemovedLog(Location logLocation, String playerUUID) {
        String playerKey = playerUUID;
        for (Map.Entry<String, Set<Location>> entry : removedLogsPerSession.entrySet()) {
            if (!entry.getKey().startsWith(playerKey + "_")) continue;
            entry.getValue().add(logLocation.clone());
        }
    }

    private static void scheduleDelayedLeafRemoval(Block originalLogBlock, boolean netherFungus, Player player, AutoTreeChopPlus plugin, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook, Set<Location> checkedLeafLocations, Set<Location> processingLeafLocations, String sessionId, String playerKey) {
        Runnable delayedTask = () -> LeafRemovalUtils.startLeafRemoval(originalLogBlock, netherFungus, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, checkedLeafLocations, processingLeafLocations, sessionId, playerKey);
        if (AutoTreeChopPlus.isFolia()) {
            plugin.getServer().getRegionScheduler().runDelayed((Plugin)plugin, originalLogBlock.getLocation(), task -> delayedTask.run(), Math.max(config.getLeafRemovalDelayTicks(), 60L));
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, delayedTask, Math.max(config.getLeafRemovalDelayTicks(), 60L));
        }
    }

    private static void startLeafRemoval(Block originalLogBlock, boolean netherFungus, Player player, AutoTreeChopPlus plugin, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook, Set<Location> checkedLeafLocations, Set<Location> processingLeafLocations, String sessionId, String playerKey) {
        Collection<Block> leavesToRemove = LeafRemovalUtils.findLeavesToRemove(originalLogBlock, config.getLeafRemovalRadius(), checkedLeafLocations, config, sessionId, netherFungus);
        if (leavesToRemove.isEmpty()) {
            LeafRemovalUtils.cleanupSession(sessionId, playerKey);
            return;
        }
        ArrayList<Block> leavesList = new ArrayList<Block>(leavesToRemove);
        int batchSize = config.getLeafRemovalBatchSize();
        LeafRemovalUtils.processLeavesBatch(leavesList, 0, batchSize, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, processingLeafLocations, sessionId, playerKey);
    }

    private static void processLeavesBatch(List<Block> leavesList, int startIndex, int batchSize, Player player, AutoTreeChopPlus plugin, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook, Set<Location> processingLeafLocations, String sessionId, String playerKey) {
        int endIndex = Math.min(startIndex + batchSize, leavesList.size());
        int leavesRemovedThisBatch = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            Block leafBlock = leavesList.get(i);
            if (config.getLeafRemovalCountsTowardsLimit() && !PermissionUtils.hasVipBlock(player, playerConfig, config) && playerConfig.getDailyBlocksBroken() >= config.getMaxBlocksPerDay()) break;
            if (!LeafRemovalUtils.removeLeafBlock(leafBlock, player, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, processingLeafLocations)) continue;
            ++leavesRemovedThisBatch;
        }
        if (endIndex < leavesList.size() && leavesRemovedThisBatch > 0) {
            Runnable nextBatchTask = () -> LeafRemovalUtils.processLeavesBatch(leavesList, endIndex, batchSize, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook, processingLeafLocations, sessionId, playerKey);
            if (AutoTreeChopPlus.isFolia()) {
                plugin.getServer().getRegionScheduler().runDelayed((Plugin)plugin, leavesList.get(endIndex).getLocation(), task -> nextBatchTask.run(), 1L);
            } else {
                Bukkit.getScheduler().runTaskLater((Plugin)plugin, nextBatchTask, 1L);
            }
        } else if (endIndex >= leavesList.size()) {
            LeafRemovalUtils.cleanupSession(sessionId, playerKey);
        }
    }

    private static void cleanupSession(String sessionId, String playerKey) {
        removedLogsPerSession.remove(sessionId);
        activeLeafRemovalSessions.remove(playerKey);
    }

    private static boolean removeLeafBlock(Block leafBlock, Player player, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook, Set<Location> processingLeafLocations) {
        Location leafLocation = leafBlock.getLocation();
        if (processingLeafLocations.contains(leafLocation)) {
            return false;
        }
        if (!(TreeChopUtils.resCheck(player, leafLocation, residenceEnabled, residenceHook) && TreeChopUtils.landsCheck(player, leafLocation, landsEnabled, landsHook) && TreeChopUtils.gfCheck(player, leafLocation, griefPreventionEnabled, griefPreventionHook) && TreeChopUtils.wgCheck(player, leafLocation, worldGuardEnabled, worldGuardHook))) {
            return false;
        }
        processingLeafLocations.add(leafLocation);
        BlockBreakEvent breakEvent = new BlockBreakEvent(leafBlock, player);
        Bukkit.getPluginManager().callEvent((Event)breakEvent);
        if (!breakEvent.isCancelled()) {
            if (config.getLeafRemovalVisualEffects()) {
                EffectUtils.showLeafRemovalEffect(player, leafBlock);
            }
            if (config.getLeafRemovalDropItems()) {
                leafBlock.breakNaturally();
            } else {
                leafBlock.setType(Material.AIR);
            }
            if (config.getLeafRemovalCountsTowardsLimit()) {
                playerConfig.incrementDailyBlocksBroken();
            }
            processingLeafLocations.remove(leafLocation);
            return true;
        }
        processingLeafLocations.remove(leafLocation);
        return false;
    }

    private static Collection<Block> findLeavesToRemove(Block centerBlock, int radius, Set<Location> checkedLocations, Config config, String sessionId, boolean netherFungus) {
        HashSet<Block> leavesToRemove = new HashSet<Block>();
        HashSet<Location> visitedInThisSearch = new HashSet<Location>();
        Location center = centerBlock.getLocation();
        int scanRadius = radius;
        Set<Location> removedLogs = removedLogsPerSession.get(sessionId);
        if (removedLogs == null) {
            removedLogs = new HashSet<Location>();
        }
        for (int x = -scanRadius; x <= scanRadius; ++x) {
            for (int y = -scanRadius; y <= scanRadius; ++y) {
                for (int z = -scanRadius; z <= scanRadius; ++z) {
                    Location checkLoc = center.clone().add((double)x, (double)y, (double)z);
                    Block checkBlock = checkLoc.getBlock();
                    if (!LeafRemovalUtils.isLeafBlock(checkBlock.getType(), config) || checkedLocations.contains(checkLoc) || visitedInThisSearch.contains(checkLoc)) continue;
                    if (LeafRemovalUtils.isOrphanedLeaf(checkBlock, config, removedLogs, netherFungus)) {
                        leavesToRemove.add(checkBlock);
                    }
                    visitedInThisSearch.add(checkLoc);
                }
            }
        }
        checkedLocations.addAll(visitedInThisSearch);
        return leavesToRemove;
    }

    private static boolean isOrphanedLeaf(Block leafBlock, Config config, Set<Location> removedLogs, boolean netherFungus) {
        String mode;
        if (netherFungus && LeafRemovalUtils.isNetherFungusLeaf(leafBlock.getType())) {
            return LeafRemovalUtils.isConnectedToRemovedLog(leafBlock, removedLogs, new HashSet<Location>(), 0);
        }
        switch (mode = config.getLeafRemovalMode().toLowerCase()) {
            case "aggressive": {
                return true;
            }
            case "radius": {
                return !LeafRemovalUtils.hasNearbyActiveLog(leafBlock.getLocation(), config, removedLogs, 4);
            }
        }
        Location leafLoc = leafBlock.getLocation();
        if (!LeafRemovalUtils.hasNearbyActiveLog(leafLoc, config, removedLogs, 6)) {
            return true;
        }
        return !LeafRemovalUtils.isConnectedToActiveLog(leafBlock, config, removedLogs, new HashSet<Location>(), 0);
    }

    private static boolean hasNearbyActiveLog(Location leafLoc, Config config, Set<Location> removedLogs, int checkRadius) {
        for (int x = -checkRadius; x <= checkRadius; ++x) {
            for (int y = -checkRadius; y <= checkRadius; ++y) {
                for (int z = -checkRadius; z <= checkRadius; ++z) {
                    Location checkLoc;
                    Block checkBlock;
                    if (x == 0 && y == 0 && z == 0 || !TreeChopUtils.isLog((checkBlock = (checkLoc = leafLoc.clone().add((double)x, (double)y, (double)z)).getBlock()).getType(), config) || removedLogs.contains(checkLoc)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConnectedToActiveLog(Block startBlock, Config config, Set<Location> removedLogs, Set<Location> visited, int depth) {
        if (depth > 8 || visited.size() > 100) {
            return false;
        }
        Location startLoc = startBlock.getLocation();
        if (visited.contains(startLoc)) {
            return false;
        }
        visited.add(startLoc);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Location checkLoc = startLoc.clone().add((double)x, (double)y, (double)z);
                    Block checkBlock = checkLoc.getBlock();
                    Material checkType = checkBlock.getType();
                    if (TreeChopUtils.isLog(checkType, config) && !removedLogs.contains(checkLoc)) {
                        return true;
                    }
                    if (!LeafRemovalUtils.isLeafBlock(checkType, config) || visited.contains(checkLoc) || !LeafRemovalUtils.isConnectedToActiveLog(checkBlock, config, removedLogs, visited, depth + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConnectedToRemovedLog(Block startBlock, Set<Location> removedLogs, Set<Location> visited, int depth) {
        if (removedLogs == null || removedLogs.isEmpty()) {
            return true;
        }
        if (depth > 12 || visited.size() > 200) {
            return false;
        }
        Location startLoc = startBlock.getLocation();
        if (!visited.add(startLoc)) {
            return false;
        }
        if (removedLogs.contains(startLoc)) {
            return true;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    Location checkLoc = startLoc.clone().add((double)x, (double)y, (double)z);
                    if (removedLogs.contains(checkLoc)) {
                        return true;
                    }
                    Block neighbourBlock = checkLoc.getBlock();
                    Material neighbourType = neighbourBlock.getType();
                    if (!LeafRemovalUtils.isNetherFungusLeaf(neighbourType) && !NETHER_FUNGUS_LOGS.contains(neighbourType) || !LeafRemovalUtils.isConnectedToRemovedLog(neighbourBlock, removedLogs, visited, depth + 1)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isLeafBlock(Material material, Config config) {
        return config.getLeafTypes().contains(material);
    }

    private static boolean isNetherFungusLeaf(Material material) {
        return NETHER_FUNGUS_LEAVES.contains(material);
    }

    private static boolean isNetherFungusLog(Material material) {
        return material != null && NETHER_FUNGUS_LOGS.contains(material);
    }
}

