/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.utils;

import java.util.Random;
import java.util.Set;
import org.atcplus.autotreechopplus.AutoTreeChopPlus;
import org.atcplus.autotreechopplus.Config;
import org.atcplus.autotreechopplus.PlayerConfig;
import org.atcplus.autotreechopplus.hooks.GriefPreventionHook;
import org.atcplus.autotreechopplus.hooks.LandsHook;
import org.atcplus.autotreechopplus.hooks.ResidenceHook;
import org.atcplus.autotreechopplus.hooks.WorldGuardHook;
import org.atcplus.autotreechopplus.utils.LeafRemovalUtils;
import org.atcplus.autotreechopplus.utils.PermissionUtils;
import org.atcplus.autotreechopplus.utils.TreeReplantUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class TreeChopUtils {
    private static final Random random = new Random();

    public static void chopTree(Block block, Player player, boolean ConnectedBlocks, ItemStack tool, Location location, Material material, BlockData blockData, AutoTreeChopPlus plugin, Set<Location> processingLocations, Set<Location> checkedLocations, Config config, PlayerConfig playerConfig, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook) {
        if (!(TreeChopUtils.resCheck(player, location, residenceEnabled, residenceHook) && TreeChopUtils.landsCheck(player, location, landsEnabled, landsHook) && TreeChopUtils.gfCheck(player, location, griefPreventionEnabled, griefPreventionHook) && TreeChopUtils.wgCheck(player, location, worldGuardEnabled, worldGuardHook))) {
            return;
        }
        if (checkedLocations.contains(block.getLocation()) || processingLocations.contains(block.getLocation())) {
            return;
        }
        checkedLocations.add(block.getLocation());
        if (!TreeChopUtils.isLog(block.getType(), config)) {
            return;
        }
        if (config.getMustUseTool() && !TreeChopUtils.isTool(player)) {
            return;
        }
        processingLocations.add(block.getLocation());
        BlockBreakEvent breakEvent = new BlockBreakEvent(block, player);
        Bukkit.getPluginManager().callEvent((Event)breakEvent);
        if (!breakEvent.isCancelled()) {
            Material originalLogType = block.getType();
            block.breakNaturally();
            LeafRemovalUtils.trackRemovedLog(block.getLocation(), player.getUniqueId().toString());
            LeafRemovalUtils.processLeafRemoval(block, originalLogType, player, plugin, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook);
            if (TreeReplantUtils.isReplantEnabledForPlayer(player, config)) {
                TreeReplantUtils.scheduleReplant(player, block, originalLogType, plugin, config, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook);
            }
            if (config.getPlayBreakSound()) {
                block.getWorld().playSound(block.getLocation(), Sound.BLOCK_WOOD_BREAK, 1.0f, 1.0f);
            }
            playerConfig.incrementDailyBlocksBroken();
            if (config.isToolDamage()) {
                TreeChopUtils.damageTool(tool, player, config.getToolDamageDecrease(), config);
            }
            Runnable task = () -> {
                for (int yOffset = -1; yOffset <= 1; ++yOffset) {
                    for (int xOffset = -1; xOffset <= 1; ++xOffset) {
                        for (int zOffset = -1; zOffset <= 1; ++zOffset) {
                            if (xOffset == 0 && yOffset == 0 && zOffset == 0) continue;
                            Block relativeBlock = block.getRelative(xOffset, yOffset, zOffset);
                            if (config.isStopChoppingIfDifferentTypes() && TreeChopUtils.notSameType(block.getType(), relativeBlock.getType()) || ConnectedBlocks && TreeChopUtils.blockNotConnected(block, relativeBlock)) continue;
                            if (!PermissionUtils.hasVipUses(player, playerConfig, config) && playerConfig.getDailyUses() >= config.getMaxUsesPerDay()) {
                                AutoTreeChopPlus.sendMessage((CommandSender)player, AutoTreeChopPlus.HIT_MAX_USAGE_MESSAGE);
                                return;
                            }
                            if (!PermissionUtils.hasVipBlock(player, playerConfig, config) && playerConfig.getDailyBlocksBroken() >= config.getMaxBlocksPerDay()) {
                                AutoTreeChopPlus.sendMessage((CommandSender)player, AutoTreeChopPlus.HIT_MAX_BLOCK_MESSAGE);
                                return;
                            }
                            if (AutoTreeChopPlus.isFolia()) {
                                plugin.getServer().getRegionScheduler().run((Plugin)plugin, relativeBlock.getLocation(), task2 -> TreeChopUtils.chopTree(relativeBlock, player, ConnectedBlocks, tool, location, material, blockData, plugin, processingLocations, checkedLocations, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook));
                                continue;
                            }
                            if (config.isChopTreeAsync()) {
                                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> Bukkit.getScheduler().runTask((Plugin)plugin, () -> TreeChopUtils.chopTree(relativeBlock, player, ConnectedBlocks, tool, location, material, blockData, plugin, processingLocations, checkedLocations, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook)));
                                continue;
                            }
                            Bukkit.getScheduler().runTask((Plugin)plugin, () -> TreeChopUtils.chopTree(relativeBlock, player, ConnectedBlocks, tool, location, material, blockData, plugin, processingLocations, checkedLocations, config, playerConfig, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook));
                        }
                    }
                }
                processingLocations.remove(block.getLocation());
            };
            if (!AutoTreeChopPlus.isFolia() && config.isChopTreeAsync()) {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, task);
            } else {
                task.run();
            }
        } else {
            processingLocations.remove(block.getLocation());
        }
    }

    private static void damageTool(ItemStack tool, Player player, int amount, Config config) {
        ItemMeta itemMeta;
        if (tool.getType().getMaxDurability() > 0 && (itemMeta = tool.getItemMeta()) instanceof Damageable) {
            Damageable damageableMeta = (Damageable)itemMeta;
            int unbreakingLevel = TreeChopUtils.getUnbreakingLevel(tool);
            for (int i = 0; i < amount; ++i) {
                if (!TreeChopUtils.shouldApplyDurabilityLoss(unbreakingLevel, config)) continue;
                int currentDamage = damageableMeta.getDamage();
                int newDamage = currentDamage + 1;
                if (newDamage >= tool.getType().getMaxDurability()) {
                    player.getInventory().removeItem(new ItemStack[]{tool});
                    break;
                }
                damageableMeta.setDamage(newDamage);
                tool.setItemMeta((ItemMeta)damageableMeta);
            }
        }
    }

    private static int getUnbreakingLevel(ItemStack item) {
        if (item != null && item.hasItemMeta() && item.getItemMeta().hasEnchants()) {
            return item.getEnchantmentLevel(Enchantment.DURABILITY);
        }
        return 0;
    }

    private static boolean shouldApplyDurabilityLoss(int unbreakingLevel, Config config) {
        if (unbreakingLevel <= 0) {
            return true;
        }
        if (!config.getRespectUnbreaking()) {
            return true;
        }
        return (double)random.nextInt(100) < 100.0 / (double)(unbreakingLevel + 1);
    }

    public static boolean landsCheck(Player player, @NotNull Location location, boolean landsEnabled, LandsHook landsHook) {
        return !landsEnabled || landsHook.checkBuild(player, location);
    }

    public static boolean wgCheck(Player player, Location location, boolean worldGuardEnabled, WorldGuardHook worldGuardHook) {
        if (!worldGuardEnabled) {
            return true;
        }
        return worldGuardHook.checkBuild(player, location);
    }

    public static boolean gfCheck(Player player, Location location, boolean griefPreventionEnabled, GriefPreventionHook griefPreventionHook) {
        return !griefPreventionEnabled || griefPreventionHook.checkBuild(player, location);
    }

    private static boolean blockNotConnected(Block block1, Block block2) {
        if (block1.getX() == block2.getX() && block1.getY() == block2.getY() && Math.abs(block1.getZ() - block2.getZ()) == 1) {
            return false;
        }
        if (block1.getX() == block2.getX() && Math.abs(block1.getY() - block2.getY()) == 1 && block1.getZ() == block2.getZ()) {
            return false;
        }
        return Math.abs(block1.getX() - block2.getX()) != 1 || block1.getY() != block2.getY() || block1.getZ() != block2.getZ();
    }

    static boolean resCheck(Player player, Location location, boolean residenceEnabled, ResidenceHook residenceHook) {
        return !residenceEnabled || residenceHook.checkBuild(player, location);
    }

    private static boolean notSameType(Material type1, Material type2) {
        return type1 != type2;
    }

    public static boolean isLog(Material material, Config config) {
        return config.getLogTypes().contains(material);
    }

    public static boolean isTool(Player player) {
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        Material material = item.getType();
        if (material.toString().endsWith("_AXE")) {
            return true;
        }
        if (material.toString().endsWith("_HOE")) {
            return true;
        }
        if (material.toString().endsWith("_PICKAXE")) {
            return true;
        }
        if (material.toString().endsWith("_SHOVEL")) {
            return true;
        }
        if (material.toString().endsWith("_SWORD")) {
            return true;
        }
        if (material == Material.SHEARS) {
            return true;
        }
        if (material == Material.FISHING_ROD) {
            return true;
        }
        return material == Material.FLINT_AND_STEEL;
    }
}

