/*
 * Decompiled with CFR 0.152.
 */
package org.atcplus.autotreechopplus.utils;

import org.atcplus.autotreechopplus.AutoTreeChopPlus;
import org.atcplus.autotreechopplus.Config;
import org.atcplus.autotreechopplus.hooks.GriefPreventionHook;
import org.atcplus.autotreechopplus.hooks.LandsHook;
import org.atcplus.autotreechopplus.hooks.ResidenceHook;
import org.atcplus.autotreechopplus.hooks.WorldGuardHook;
import org.atcplus.autotreechopplus.utils.EffectUtils;
import org.atcplus.autotreechopplus.utils.TreeChopUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;

public class TreeReplantUtils {
    public static void scheduleReplant(Player player, Block brokenLogBlock, Material originalLogType, AutoTreeChopPlus plugin, Config config, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook) {
        if (!config.isAutoReplantEnabled()) {
            return;
        }
        Material saplingType = config.getSaplingForLog(originalLogType);
        if (saplingType == null) {
            return;
        }
        Block below = brokenLogBlock.getRelative(BlockFace.DOWN);
        if (!TreeReplantUtils.isValidSoil(below.getType(), config)) {
            return;
        }
        Location plantLocation = TreeReplantUtils.findSuitablePlantLocation(brokenLogBlock.getLocation(), config);
        if (plantLocation == null) {
            return;
        }
        Runnable replantTask = () -> {
            if (!TreeReplantUtils.hasReplantPermission(player, plantLocation, worldGuardEnabled, residenceEnabled, griefPreventionEnabled, landsEnabled, landsHook, residenceHook, griefPreventionHook, worldGuardHook)) {
                return;
            }
            boolean planted = TreeReplantUtils.plantSapling(player, plantLocation, saplingType, config);
            if (planted && config.getReplantVisualEffect()) {
                EffectUtils.showReplantEffect(player, plantLocation.getBlock());
            }
        };
        long delayTicks = config.getReplantDelayTicks();
        if (AutoTreeChopPlus.isFolia()) {
            plugin.getServer().getRegionScheduler().runDelayed((Plugin)plugin, plantLocation, task -> replantTask.run(), delayTicks);
        } else {
            Bukkit.getScheduler().runTaskLater((Plugin)plugin, replantTask, delayTicks);
        }
    }

    private static Location findSuitablePlantLocation(Location originalLocation, Config config) {
        Block originalBlock = originalLocation.getBlock();
        Block belowOriginal = originalBlock.getRelative(BlockFace.DOWN);
        if (TreeReplantUtils.isValidSoil(belowOriginal.getType(), config) && TreeReplantUtils.isClearForSapling(originalBlock)) {
            return originalLocation;
        }
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Block checkBlock;
                Block belowCheck;
                if (x == 0 && z == 0 || !TreeReplantUtils.isValidSoil((belowCheck = (checkBlock = originalBlock.getRelative(x, 0, z)).getRelative(BlockFace.DOWN)).getType(), config) || !TreeReplantUtils.isClearForSapling(checkBlock)) continue;
                return checkBlock.getLocation();
            }
        }
        return null;
    }

    private static boolean isValidSoil(Material material, Config config) {
        return config.getValidSoilTypes().contains(material);
    }

    private static boolean isClearForSapling(Block block) {
        Material type = block.getType();
        return type == Material.AIR || type == Material.SHORT_GRASS || type == Material.TALL_GRASS || type == Material.FERN || type == Material.LARGE_FERN || type == Material.DEAD_BUSH;
    }

    private static boolean plantSapling(Player player, Location location, Material saplingType, Config config) {
        Block block = location.getBlock();
        if (config.getRequireSaplingInInventory() && !TreeReplantUtils.consumeSaplingFromInventory(player, saplingType)) {
            return false;
        }
        block.setType(saplingType);
        return true;
    }

    private static boolean consumeSaplingFromInventory(Player player, Material saplingType) {
        ItemStack saplingStack;
        PlayerInventory inventory = player.getInventory();
        if (inventory.containsAtLeast(saplingStack = new ItemStack(saplingType, 1), 1)) {
            inventory.removeItem(new ItemStack[]{saplingStack});
            return true;
        }
        return false;
    }

    private static boolean hasReplantPermission(Player player, Location location, boolean worldGuardEnabled, boolean residenceEnabled, boolean griefPreventionEnabled, boolean landsEnabled, LandsHook landsHook, ResidenceHook residenceHook, GriefPreventionHook griefPreventionHook, WorldGuardHook worldGuardHook) {
        return TreeChopUtils.resCheck(player, location, residenceEnabled, residenceHook) && TreeChopUtils.landsCheck(player, location, landsEnabled, landsHook) && TreeChopUtils.gfCheck(player, location, griefPreventionEnabled, griefPreventionHook) && TreeChopUtils.wgCheck(player, location, worldGuardEnabled, worldGuardHook);
    }

    public static boolean isReplantEnabledForPlayer(Player player, Config config) {
        return config.isAutoReplantEnabled() && player.hasPermission("atcplus.replant");
    }
}

