/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.addonpack.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.threetag.palladium.addonpack.AddonPackManager;
import net.threetag.palladium.addonpack.builder.AddonBuilder;
import net.threetag.palladium.addonpack.builder.SuitSetBuilder;
import net.threetag.palladium.addonpack.parser.AddonParser;
import net.threetag.palladium.item.SuitSet;
import net.threetag.palladium.util.json.GsonUtil;

public class SuitSetParser
extends AddonParser<SuitSet> {
    public SuitSetParser() {
        super(AddonParser.GSON, "suit_sets", SuitSet.REGISTRY.getRegistryKey());
    }

    @Override
    public AddonBuilder<SuitSet> parse(ResourceLocation id, JsonElement jsonElement) {
        JsonObject copy = jsonElement.getAsJsonObject().deepCopy();
        SuitSetBuilder builder = new SuitSetBuilder(id);
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            copy.remove(slot.m_20751_());
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            GsonUtil.ifHasObject(jsonElement.getAsJsonObject(), slot.m_20751_(), jsonObject -> {
                JsonObject json = GsonUtil.merge(copy, jsonObject);
                if (slot.m_20743_() == EquipmentSlot.Type.ARMOR) {
                    if (!GsonHelper.m_13900_((JsonObject)json, (String)"type")) {
                        json.addProperty("type", "palladium:armor");
                    }
                    if (!GsonHelper.m_13900_((JsonObject)json, (String)"slot")) {
                        json.addProperty("slot", slot.m_20751_());
                    }
                    if (!GsonHelper.m_13900_((JsonObject)json, (String)"armor_model_layer")) {
                        json.addProperty("armor_model_layer", slot == EquipmentSlot.LEGS ? "minecraft:player#inner_armor" : "minecraft:player#outer_armor");
                    }
                }
                String name = GsonHelper.m_13900_((JsonObject)json, (String)"item_name") ? GsonHelper.m_13906_((JsonObject)json, (String)"item_name") : id.m_135815_() + "_" + slot.m_20751_();
                AddonBuilder<Item> itemBuilder = AddonPackManager.ITEM_PARSER.parse(new ResourceLocation(id.m_135827_(), name), (JsonElement)json);
                if (slot == EquipmentSlot.MAINHAND) {
                    builder.mainHand(itemBuilder);
                } else if (slot == EquipmentSlot.OFFHAND) {
                    builder.offHand(itemBuilder);
                } else if (slot == EquipmentSlot.HEAD) {
                    builder.helmet(itemBuilder);
                } else if (slot == EquipmentSlot.CHEST) {
                    builder.chestplate(itemBuilder);
                } else if (slot == EquipmentSlot.LEGS) {
                    builder.leggings(itemBuilder);
                } else if (slot == EquipmentSlot.FEET) {
                    builder.boots(itemBuilder);
                }
                AddonParser.register(Registries.f_256913_, itemBuilder);
            });
        }
        return builder;
    }
}

