/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.block;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.Nullable;

public class BlockMaterialRegistry {
    private static final Map<ResourceLocation, MapColor> MATERIAL_COLORS = new HashMap<ResourceLocation, MapColor>();
    private static final Map<ResourceLocation, SoundType> SOUND_TYPES = new HashMap<ResourceLocation, SoundType>();

    public static void registerColor(ResourceLocation id, MapColor materialColor) {
        MATERIAL_COLORS.put(id, materialColor);
    }

    @Nullable
    public static MapColor getColor(ResourceLocation id) {
        return MATERIAL_COLORS.get(id);
    }

    public static Set<ResourceLocation> getAllColorIds() {
        return MATERIAL_COLORS.keySet();
    }

    public static Collection<MapColor> getAllColors() {
        return MATERIAL_COLORS.values();
    }

    public static void registerSoundType(ResourceLocation id, SoundType soundType) {
        SOUND_TYPES.put(id, soundType);
    }

    @Nullable
    public static SoundType getSoundType(ResourceLocation id) {
        return SOUND_TYPES.get(id);
    }

    public static Set<ResourceLocation> getAllSoundTypeIds() {
        return SOUND_TYPES.keySet();
    }

    public static Collection<SoundType> getAllSoundTypes() {
        return SOUND_TYPES.values();
    }

    static {
        BlockMaterialRegistry.registerColor(new ResourceLocation("none"), MapColor.f_283808_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("grass"), MapColor.f_283824_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("sand"), MapColor.f_283761_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("wool"), MapColor.f_283930_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("fire"), MapColor.f_283816_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("ice"), MapColor.f_283828_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("metal"), MapColor.f_283906_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("plant"), MapColor.f_283915_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("snow"), MapColor.f_283811_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("clay"), MapColor.f_283744_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("dirt"), MapColor.f_283762_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("stone"), MapColor.f_283947_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("water"), MapColor.f_283864_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("wood"), MapColor.f_283825_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("quartz"), MapColor.f_283942_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_orange"), MapColor.f_283750_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_magenta"), MapColor.f_283931_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_light_blue"), MapColor.f_283869_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_yellow"), MapColor.f_283832_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_light_green"), MapColor.f_283916_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_pink"), MapColor.f_283765_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_gray"), MapColor.f_283818_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_light_gray"), MapColor.f_283779_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_cyan"), MapColor.f_283772_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_purple"), MapColor.f_283889_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_blue"), MapColor.f_283743_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_brown"), MapColor.f_283748_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_green"), MapColor.f_283784_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_red"), MapColor.f_283913_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("color_black"), MapColor.f_283927_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("gold"), MapColor.f_283757_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("diamond"), MapColor.f_283821_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("lapis"), MapColor.f_283933_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("emerald"), MapColor.f_283812_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("podzol"), MapColor.f_283819_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("nether"), MapColor.f_283820_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_orange"), MapColor.f_283895_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_magenta"), MapColor.f_283850_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_light_blue"), MapColor.f_283791_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_yellow"), MapColor.f_283843_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_light_green"), MapColor.f_283778_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_pink"), MapColor.f_283870_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_gray"), MapColor.f_283861_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_light_gray"), MapColor.f_283907_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_cyan"), MapColor.f_283846_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_purple"), MapColor.f_283892_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_blue"), MapColor.f_283908_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_brown"), MapColor.f_283774_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_green"), MapColor.f_283856_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_red"), MapColor.f_283798_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("terracotta_black"), MapColor.f_283771_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("crimson_nylium"), MapColor.f_283909_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("crimson_stem"), MapColor.f_283804_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("crimson_hyphae"), MapColor.f_283883_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("warped_nylium"), MapColor.f_283745_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("warped_stem"), MapColor.f_283749_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("warped_hyphae"), MapColor.f_283807_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("warped_wart_block"), MapColor.f_283898_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("deepslate"), MapColor.f_283875_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("raw_iron"), MapColor.f_283877_);
        BlockMaterialRegistry.registerColor(new ResourceLocation("glow_lichen"), MapColor.f_283769_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("wood"), SoundType.f_56736_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("gravel"), SoundType.f_56739_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("grass"), SoundType.f_56740_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("lily_pad"), SoundType.f_56741_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("stone"), SoundType.f_56742_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("metal"), SoundType.f_56743_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("glass"), SoundType.f_56744_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("wool"), SoundType.f_56745_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("sand"), SoundType.f_56746_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("snow"), SoundType.f_56747_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("powder_snow"), SoundType.f_154681_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("ladder"), SoundType.f_56748_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("anvil"), SoundType.f_56749_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("slime_block"), SoundType.f_56750_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("honey_block"), SoundType.f_56751_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("wet_grass"), SoundType.f_56752_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("coral_block"), SoundType.f_56753_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("bamboo"), SoundType.f_56754_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("bamboo_sapling"), SoundType.f_56755_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("scaffolding"), SoundType.f_56756_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("sweet_berry_bush"), SoundType.f_56757_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("crop"), SoundType.f_56758_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("hard_crop"), SoundType.f_56759_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("vine"), SoundType.f_56760_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("nether_wart"), SoundType.f_56761_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("lantern"), SoundType.f_56762_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("stem"), SoundType.f_56763_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("nylium"), SoundType.f_56710_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("fungus"), SoundType.f_56711_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("root"), SoundType.f_56712_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("shroomlight"), SoundType.f_56713_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("weeping_vines"), SoundType.f_56714_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("twisting_vines"), SoundType.f_56715_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("soul_sand"), SoundType.f_56716_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("soul_soil"), SoundType.f_56717_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("basalt"), SoundType.f_56718_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("wart_block"), SoundType.f_56719_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("netherrack"), SoundType.f_56720_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("nether_bricks"), SoundType.f_56721_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("nether_sprouts"), SoundType.f_56722_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("nether_ore"), SoundType.f_56723_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("bone_block"), SoundType.f_56724_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("netherite_block"), SoundType.f_56725_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("ancient_debris"), SoundType.f_56726_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("lodestone"), SoundType.f_56727_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("chain"), SoundType.f_56728_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("nether_gold_ore"), SoundType.f_56729_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("gilded_blackstone"), SoundType.f_56730_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("candle"), SoundType.f_154653_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("amethyst"), SoundType.f_154654_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("amethyst_cluster"), SoundType.f_154655_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("small_amethyst_bud"), SoundType.f_154656_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("medium_amethyst_bud"), SoundType.f_154657_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("large_amethyst_bud"), SoundType.f_154658_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("tuff"), SoundType.f_154659_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("calcite"), SoundType.f_154660_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("dripstone_block"), SoundType.f_154661_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("pointed_dripstone"), SoundType.f_154662_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("copper"), SoundType.f_154663_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("cave_vines"), SoundType.f_154664_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("spore_blossom"), SoundType.f_154665_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("azalea"), SoundType.f_154666_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("flowering_azalea"), SoundType.f_154667_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("moss_carpet"), SoundType.f_154668_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("moss"), SoundType.f_154669_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("big_dripleaf"), SoundType.f_154670_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("small_dripleaf"), SoundType.f_154671_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("rooted_dirt"), SoundType.f_154672_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("hanging_roots"), SoundType.f_154673_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("azelea_leaves"), SoundType.f_154674_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("sculk_sensor"), SoundType.f_154675_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("sculk_catalyst"), SoundType.f_222472_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("sculk"), SoundType.f_222473_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("sculk_vein"), SoundType.f_222474_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("sculk_shrieker"), SoundType.f_222475_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("glow_lichen"), SoundType.f_154676_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("deepslate"), SoundType.f_154677_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("deepslate_bricks"), SoundType.f_154678_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("deepslate_tiles"), SoundType.f_154679_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("polished_deepslate"), SoundType.f_154680_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("froglight"), SoundType.f_222465_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("frogspawn"), SoundType.f_222466_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("mangrove_roots"), SoundType.f_222467_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("muddy_mangrove_roots"), SoundType.f_222468_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("mud"), SoundType.f_222469_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("mud_bricks"), SoundType.f_222470_);
        BlockMaterialRegistry.registerSoundType(new ResourceLocation("packed_mud"), SoundType.f_222471_);
    }
}

