/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.client.dynamictexture.DefaultDynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.EntityDynamicTexture;
import net.threetag.palladium.client.dynamictexture.SimpleDynamicTexture;
import net.threetag.palladium.client.dynamictexture.transformer.AlphaMaskTextureTransformer;
import net.threetag.palladium.client.dynamictexture.transformer.ColorTextureTransformer;
import net.threetag.palladium.client.dynamictexture.transformer.ITextureTransformer;
import net.threetag.palladium.client.dynamictexture.transformer.OverlayTextureTransformer;
import net.threetag.palladium.client.dynamictexture.variable.AbilityFloatPropertyVariable;
import net.threetag.palladium.client.dynamictexture.variable.AbilityIdTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.AbilityIntegerPropertyVariable;
import net.threetag.palladium.client.dynamictexture.variable.AbilityTicksTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.AbilityWheelDisplayedVariable;
import net.threetag.palladium.client.dynamictexture.variable.AbilityWheelHoveredVariable;
import net.threetag.palladium.client.dynamictexture.variable.AbilityWheelSelectionTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.AccessoryVariable;
import net.threetag.palladium.client.dynamictexture.variable.AnimationTimerAbilityVariable;
import net.threetag.palladium.client.dynamictexture.variable.CapeTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ConditionTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.CrouchingTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.EnergyBarTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.EntityHealthTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.EntityTicksTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.FloatPropertyVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.client.dynamictexture.variable.IntegerPropertyVariable;
import net.threetag.palladium.client.dynamictexture.variable.ItemModelPropertyVariable;
import net.threetag.palladium.client.dynamictexture.variable.MoonPhaseTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ObjectiveScoreTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.OpenableEquipmentProgressVariable;
import net.threetag.palladium.client.dynamictexture.variable.SmallArmsTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.StringPropertyVariable;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.documentation.HTMLBuilder;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class DynamicTextureManager
extends SimpleJsonResourceReloadListener {
    private static final Map<ResourceLocation, Function<JsonObject, DynamicTexture>> TYPE_PARSERS = new HashMap<ResourceLocation, Function<JsonObject, DynamicTexture>>();
    private static final Map<ResourceLocation, Function<JsonObject, ITextureTransformer>> TRANSFORMER_PARSERS = new HashMap<ResourceLocation, Function<JsonObject, ITextureTransformer>>();
    private static final Map<ResourceLocation, ITextureVariableSerializer> VARIABLE_PARSERS = new HashMap<ResourceLocation, ITextureVariableSerializer>();
    private static final Gson GSON;
    public static DynamicTextureManager INSTANCE;
    public Map<ResourceLocation, DynamicTexture> byName = ImmutableMap.of();

    public DynamicTextureManager() {
        super(GSON, "palladium/dynamic_textures");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((id, json) -> {
            try {
                builder.put(id, (Object)DynamicTextureManager.fromJson(json));
            }
            catch (Exception e) {
                AddonPackLog.error("Parsing error loading dynamic texture {}", id, e);
            }
        });
        this.byName = builder.build();
        AddonPackLog.info("Loaded {} dynamic textures", this.byName.size());
    }

    @Nullable
    public DynamicTexture get(ResourceLocation id) {
        return this.byName.get(id);
    }

    public static DynamicTexture fromJson(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            String input = jsonElement.getAsString();
            if (input.equalsIgnoreCase("#entity")) {
                return new EntityDynamicTexture(false);
            }
            if (input.startsWith("#")) {
                DynamicTexture dyn = INSTANCE.get(new ResourceLocation(input.substring(1)));
                if (dyn == null) {
                    throw new JsonParseException("Dynamic texture '" + String.valueOf(new ResourceLocation(input.substring(1))) + "' can not be found");
                }
                return dyn;
            }
            return new SimpleDynamicTexture(new ResourceLocation(input));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            ResourceLocation typeId = GsonUtil.getAsResourceLocation(json, "type", new ResourceLocation("palladium", "default"));
            if (!TYPE_PARSERS.containsKey(typeId)) {
                throw new JsonParseException("Unknown dynamic texture type '" + String.valueOf(typeId) + "'");
            }
            DynamicTexture texture = TYPE_PARSERS.get(typeId).apply(json);
            if (GsonHelper.m_13900_((JsonObject)json, (String)"transformers")) {
                GsonUtil.forEachInListOrPrimitive(json.get("transformers"), j -> {
                    JsonObject transformerJson = GsonHelper.m_13918_((JsonElement)j, (String)"transformers[].$");
                    ResourceLocation transformerId = GsonUtil.getAsResourceLocation(transformerJson, "type", new ResourceLocation("palladium", "default"));
                    if (TRANSFORMER_PARSERS.containsKey(transformerId)) {
                        ITextureTransformer transformer = TRANSFORMER_PARSERS.get(transformerId).apply(transformerJson);
                        texture.transform(transformer);
                    } else {
                        AddonPackLog.error("Unknown texture transformer '" + String.valueOf(transformerId) + "'", new Object[0]);
                    }
                });
            }
            if (GsonHelper.m_13900_((JsonObject)json, (String)"variables")) {
                JsonObject variables = GsonHelper.m_13930_((JsonObject)json, (String)"variables");
                for (Map.Entry entry : variables.entrySet()) {
                    JsonObject variableJson = ((JsonElement)entry.getValue()).getAsJsonObject();
                    ResourceLocation variableId = GsonUtil.getAsResourceLocation(variableJson, "type");
                    if (VARIABLE_PARSERS.containsKey(variableId)) {
                        ITextureVariable variable = VARIABLE_PARSERS.get(variableId).parse(variableJson);
                        texture.addVariable((String)entry.getKey(), variable);
                        continue;
                    }
                    AddonPackLog.error("Unknown texture variable '" + String.valueOf(variableId) + "'", new Object[0]);
                }
            }
            return texture;
        }
        throw new JsonParseException("Dynamic texture must either be a primitive or object");
    }

    public static void registerType(ResourceLocation id, Function<JsonObject, DynamicTexture> function) {
        TYPE_PARSERS.put(id, function);
    }

    public static void registerTransformer(ResourceLocation id, Function<JsonObject, ITextureTransformer> function) {
        TRANSFORMER_PARSERS.put(id, function);
    }

    public static void registerVariable(ITextureVariableSerializer serializer) {
        VARIABLE_PARSERS.put(serializer.getId(), serializer);
    }

    @Nullable
    public static ITextureVariableSerializer getTextureVariableSerializer(ResourceLocation id) {
        return VARIABLE_PARSERS.get(id);
    }

    public static HTMLBuilder variableDocumentationBuilder() {
        return new HTMLBuilder(new ResourceLocation("palladium", "dynamic_textures/variables"), "Dynamic Texture Variables").add(HTMLBuilder.heading("Dynamic Texture Variables")).addDocumentationSettings(VARIABLE_PARSERS.values().stream().sorted(Comparator.comparing(o -> o.getId().toString())).collect(Collectors.toList()));
    }

    static {
        DynamicTextureManager.registerType(Palladium.id("simple"), j -> new SimpleDynamicTexture(GsonUtil.getAsResourceLocation(j, "texture")));
        DynamicTextureManager.registerType(Palladium.id("default"), j -> new DefaultDynamicTexture(GsonHelper.m_13906_((JsonObject)j, (String)"base"), GsonHelper.m_13851_((JsonObject)j, (String)"output", (String)"")));
        DynamicTextureManager.registerType(Palladium.id("entity"), j -> new EntityDynamicTexture(GsonHelper.m_13855_((JsonObject)j, (String)"ignore_skin_change", (boolean)false)));
        DynamicTextureManager.registerTransformer(Palladium.id("alpha_mask"), j -> new AlphaMaskTextureTransformer(GsonHelper.m_13906_((JsonObject)j, (String)"mask")));
        DynamicTextureManager.registerTransformer(Palladium.id("overlay"), j -> new OverlayTextureTransformer(GsonHelper.m_13906_((JsonObject)j, (String)"overlay"), GsonHelper.m_13855_((JsonObject)j, (String)"ignore_blank", (boolean)false)));
        DynamicTextureManager.registerTransformer(Palladium.id("color"), j -> new ColorTextureTransformer(DynamicColor.getFromJson(j, "color"), GsonHelper.m_13912_((JsonObject)j, (String)"ignore_blank"), DynamicColor.getFromJson(j, "filter", null)));
        DynamicTextureManager.registerVariable(new ConditionTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new CrouchingTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new SmallArmsTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new AbilityTicksTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new EntityTicksTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new AbilityIntegerPropertyVariable.Serializer());
        DynamicTextureManager.registerVariable(new AbilityFloatPropertyVariable.Serializer());
        DynamicTextureManager.registerVariable(new EntityHealthTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new MoonPhaseTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new IntegerPropertyVariable.Serializer());
        DynamicTextureManager.registerVariable(new FloatPropertyVariable.Serializer());
        DynamicTextureManager.registerVariable(new CapeTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new AbilityIdTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new OpenableEquipmentProgressVariable.Serializer());
        DynamicTextureManager.registerVariable(new ObjectiveScoreTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new AnimationTimerAbilityVariable.Serializer());
        DynamicTextureManager.registerVariable(new EnergyBarTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new AccessoryVariable.Serializer());
        DynamicTextureManager.registerVariable(new StringPropertyVariable.Serializer());
        DynamicTextureManager.registerVariable(new AbilityWheelSelectionTextureVariable.Serializer());
        DynamicTextureManager.registerVariable(new AbilityWheelHoveredVariable.Serializer());
        DynamicTextureManager.registerVariable(new AbilityWheelDisplayedVariable.Serializer());
        DynamicTextureManager.registerVariable(new ItemModelPropertyVariable.Serializer());
        GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    }
}

