/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.transformer;

import com.mojang.blaze3d.platform.NativeImage;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.threetag.palladium.client.dynamictexture.transformer.ITextureTransformer;
import net.threetag.palladium.util.context.DataContext;

public record AlphaMaskTextureTransformer(String maskLocation) implements ITextureTransformer
{
    @Override
    public NativeImage transform(DataContext context, NativeImage texture, ResourceManager manager, Function<String, String> stringConverter) throws IOException {
        NativeImage overlay = NativeImage.m_85058_((InputStream)((Resource)manager.m_213713_(new ResourceLocation(stringConverter.apply(this.maskLocation))).get()).m_215507_());
        for (int y = 0; y < overlay.m_85084_(); ++y) {
            for (int x = 0; x < overlay.m_84982_(); ++x) {
                int pixelOrig = texture.m_84985_(x, y);
                int pixelMask = overlay.m_84985_(x, y);
                if (pixelOrig == 0) continue;
                Color color = new Color(pixelMask, true);
                Color colorOrig = new Color(pixelOrig, true);
                float hue = 1.0f - (float)(color.getRed() + color.getGreen() + color.getBlue()) / 3.0f / 255.0f;
                int newAlpha = pixelMask == 0 ? 0 : (int)((float)colorOrig.getAlpha() * hue);
                Color newColor = new Color(colorOrig.getRed(), colorOrig.getGreen(), colorOrig.getBlue(), newAlpha);
                texture.m_84988_(x, y, newColor.getRGB());
            }
        }
        overlay.close();
        return texture;
    }
}

