/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.transformer;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.threetag.palladium.client.dynamictexture.transformer.ITextureTransformer;
import net.threetag.palladium.util.context.DataContext;

public class TransformedTexture
extends SimpleTexture {
    private final List<ITextureTransformer> transformers;
    private final DataContext context;
    private final Function<String, String> stringConverter;

    public TransformedTexture(ResourceLocation base, List<ITextureTransformer> transformers, DataContext context, Function<String, String> stringConverter) {
        super(base);
        this.transformers = transformers;
        this.context = context;
        this.stringConverter = stringConverter;
    }

    public void m_6704_(ResourceManager manager) {
        Minecraft.m_91087_().execute(() -> {
            this.m_117964_();
            InputStream textureStream = null;
            try {
                textureStream = ((Resource)manager.m_213713_(this.f_118129_).get()).m_215507_();
                NativeImage image = NativeImage.m_85058_((InputStream)textureStream);
                for (ITextureTransformer transformer : this.transformers) {
                    image = transformer.transform(this.context, image, manager, this.stringConverter);
                }
                TextureUtil.prepareImage((int)this.m_117963_(), (int)image.m_84982_(), (int)image.m_85084_());
                image.m_85040_(0, 0, 0, false);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                if (textureStream != null) {
                    try {
                        textureStream.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

