/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractIntegerTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;

public class AbilityIntegerPropertyVariable
extends AbstractIntegerTextureVariable {
    private final AbilityReference reference;
    private final String propertyKey;
    private final int fallbackValue;

    public AbilityIntegerPropertyVariable(ResourceLocation powerId, String abilityId, String propertyKey, int fallbackValue, List<Pair<AbstractIntegerTextureVariable.Operation, Integer>> operations) {
        super(operations);
        this.reference = new AbilityReference(powerId, abilityId);
        this.propertyKey = propertyKey;
        this.fallbackValue = fallbackValue;
    }

    @Override
    public int getNumber(DataContext context) {
        LivingEntity livingEntity = context.getLivingEntity();
        if (livingEntity != null) {
            AbilityInstance entry = this.reference.getEntry(livingEntity);
            if (entry == null) {
                return this.fallbackValue;
            }
            PalladiumProperty<?> property = entry.getEitherPropertyByKey(this.propertyKey);
            if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                return entry.getProperty(integerProperty);
            }
        }
        return this.fallbackValue;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new AbilityIntegerPropertyVariable(GsonUtil.getAsResourceLocation(json, "power"), GsonHelper.m_13906_((JsonObject)json, (String)"ability"), GsonHelper.m_13906_((JsonObject)json, (String)"property"), GsonHelper.m_13824_((JsonObject)json, (String)"fallback", (int)0), AbstractIntegerTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the value of an integer property of an ability (e.g. the 'value' of an animation timer). The math operations can be arranged in any order and are fully optional!";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Ability Integer-Property");
            builder.addProperty("power", ResourceLocation.class).description("ID of the power the ability is in.").required().exampleJson((JsonElement)new JsonPrimitive("example:power_id"));
            builder.addProperty("ability", String.class).description("Key of the ability that is being looked for.").required().exampleJson((JsonElement)new JsonPrimitive("ability_key"));
            builder.addProperty("property", String.class).description("Name of the property you want the value from. It's 'value' for animation timer ablities.").required().exampleJson((JsonElement)new JsonPrimitive("value"));
            builder.addProperty("fallback", Integer.class).description("If the property is not found, this value will be used instead.").exampleJson((JsonElement)new JsonPrimitive((Number)0));
            AbstractIntegerTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("ability_integer_property");
        }
    }
}

