/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec2;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractFloatTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.client.model.animation.FlightAnimation;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.Easing;
import net.threetag.palladium.util.context.DataContext;

public class CapeTextureVariable
extends AbstractFloatTextureVariable {
    public final boolean bobbing;

    public CapeTextureVariable(boolean bobbing, List<Pair<AbstractFloatTextureVariable.Operation, JsonPrimitive>> operations) {
        super(operations);
        this.bobbing = bobbing;
    }

    @Override
    public float getNumber(DataContext context) {
        Player player = context.getPlayer();
        if (player != null) {
            double d0 = Mth.m_14139_((double)1.0, (double)player.f_36102_, (double)player.f_36105_) - Mth.m_14139_((double)1.0, (double)player.f_19854_, (double)player.m_20185_());
            double d1 = Mth.m_14139_((double)1.0, (double)player.f_36103_, (double)player.f_36106_) - Mth.m_14139_((double)1.0, (double)player.f_19855_, (double)player.m_20186_());
            double d2 = Mth.m_14139_((double)1.0, (double)player.f_36104_, (double)player.f_36075_) - Mth.m_14139_((double)1.0, (double)player.f_19856_, (double)player.m_20189_());
            float f = player.f_20884_ + (player.f_20883_ - player.f_20884_);
            double d3 = Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
            double d4 = -Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            float f1 = (float)d1 * 10.0f;
            f1 = Mth.m_14036_((float)f1, (float)-6.0f, (float)32.0f);
            float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
            if ((f2 = Mth.m_14036_((float)f2, (float)0.0f, (float)150.0f)) < 0.0f) {
                f2 = 0.0f;
            }
            if (this.bobbing) {
                float f4 = Mth.m_14179_((float)1.0f, (float)player.f_36099_, (float)player.f_36100_);
                f1 += Mth.m_14031_((float)(Mth.m_14179_((float)1.0f, (float)player.f_19867_, (float)player.f_19787_) * 6.0f)) * 32.0f * f4;
            }
            float rotation = 6.0f + f2 / 2.0f + f1;
            float val = Mth.m_14036_((float)(rotation + 10.0f), (float)0.0f, (float)90.0f);
            if (player instanceof PalladiumPlayerExtension) {
                Vec2 vec2;
                Vec2 vec1;
                double tilt;
                PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
                FlightHandler flight = extension.palladium$getFlightHandler();
                float hoveringAnimation = flight.getHoveringAnimation(1.0f) - flight.getLevitationAnimation(1.0f);
                if (hoveringAnimation > 0.0f) {
                    val += (20.0f - val) * hoveringAnimation;
                }
                float prevFlightAnimation = flight.getFlightAnimation(0.0f);
                float flightAnimation = flight.getFlightAnimation(1.0f);
                if (flightAnimation <= 1.0f) {
                    return val;
                }
                flightAnimation = (flightAnimation - 1.0f) / 2.0f;
                prevFlightAnimation = (prevFlightAnimation - 1.0f) / 2.0f;
                float dest = 10.0f;
                if (prevFlightAnimation > flightAnimation) {
                    dest = (1.0f - Mth.m_14036_((float)(flightAnimation * 4.0f - 3.0f), (float)0.0f, (float)1.0f)) * 70.0f;
                    flightAnimation = Mth.m_14036_((float)(flightAnimation * 3.0f), (float)0.0f, (float)1.0f);
                }
                if ((tilt = Mth.m_14008_((double)FlightAnimation.angleBetweenVector(vec1 = FlightAnimation.to2D(flight.getFlightVector(1.0f)), vec2 = FlightAnimation.to2D(flight.getLookAngle(1.0f))), (double)-0.5, (double)0.5) * 90.0 * (double)flight.getHorizontalSpeed(1.0f)) != 0.0) {
                    dest = Mth.m_14154_((float)((float)tilt));
                }
                val += (dest - val) * Easing.INOUTCIRC.apply(flightAnimation);
            }
            return val;
        }
        return 0.0f;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new CapeTextureVariable(GsonHelper.m_13855_((JsonObject)json, (String)"bobbing", (boolean)true), AbstractFloatTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the tilt of the player's cape.";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Cape");
            builder.addProperty("bobbing", Boolean.class).description("Determines of bobbing should be taken into account when doing the calculation").fallback(true).exampleJson((JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            AbstractFloatTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("cape");
        }
    }
}

