/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.dynamictexture.variable;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.Objective;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.dynamictexture.variable.AbstractIntegerTextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariable;
import net.threetag.palladium.client.dynamictexture.variable.ITextureVariableSerializer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.context.DataContext;

public class ObjectiveScoreTextureVariable
extends AbstractIntegerTextureVariable {
    private final String objectiveName;

    public ObjectiveScoreTextureVariable(String objectiveName, List<Pair<AbstractIntegerTextureVariable.Operation, Integer>> operations) {
        super(operations);
        this.objectiveName = objectiveName;
    }

    @Override
    public int getNumber(DataContext context) {
        Objective objective;
        Level level = context.getLevel();
        Entity entity = context.getEntity();
        if (level != null && entity != null && (objective = level.m_6188_().m_83477_(this.objectiveName)) != null && level.m_6188_().m_83461_(entity.m_6302_(), objective)) {
            return level.m_6188_().m_83471_(entity.m_6302_(), objective).m_83400_();
        }
        return 0;
    }

    public static class Serializer
    implements ITextureVariableSerializer {
        @Override
        public ITextureVariable parse(JsonObject json) {
            return new ObjectiveScoreTextureVariable(GsonHelper.m_13906_((JsonObject)json, (String)"objective"), AbstractIntegerTextureVariable.parseOperations(json));
        }

        @Override
        public String getDocumentationDescription() {
            return "Returns the value of a score of an entity in the scoreboard for the given objective. IF YOU USE THIS, MAKE A 'tracked_score.json' AND PUT THE OBJECTIVE NAME IN IT, MORE ON THE WIKI!";
        }

        @Override
        public void addDocumentationFields(JsonDocumentationBuilder builder) {
            builder.setTitle("Objective Score");
            builder.addProperty("objective", String.class).description("Name of the objective.").required().exampleJson((JsonElement)new JsonPrimitive("objective_name"));
            AbstractIntegerTextureVariable.addDocumentationFields(builder);
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("objective_score");
        }
    }
}

