/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.energybeam;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.client.energybeam.EnergyBeam;

public class EnergyBeamConfiguration {
    private final List<EnergyBeam> beams;

    public EnergyBeamConfiguration(List<EnergyBeam> energyBeams) {
        this.beams = energyBeams;
    }

    public void render(AbstractClientPlayer player, Vec3 anchor, Vec3 target, float lengthMultiplier, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, boolean isFirstPerson, float partialTick) {
        for (EnergyBeam beam : this.beams) {
            beam.render(player, anchor, target, lengthMultiplier, poseStack, bufferSource, packedLightIn, isFirstPerson, partialTick);
        }
    }

    public void spawnParticles(Level level, Vec3 pos) {
        for (EnergyBeam beam : this.beams) {
            beam.spawnParticles(level, pos);
        }
    }

    public static EnergyBeamConfiguration fromJson(JsonElement json) {
        if (json.isJsonArray()) {
            ArrayList<EnergyBeam> beamList = new ArrayList<EnergyBeam>();
            JsonArray array = json.getAsJsonArray();
            for (JsonElement jsonElement : array) {
                beamList.add(EnergyBeam.fromJson(GsonHelper.m_13918_((JsonElement)jsonElement, (String)"$[]")));
            }
            return new EnergyBeamConfiguration(beamList);
        }
        if (json.isJsonObject()) {
            return new EnergyBeamConfiguration(Collections.singletonList(EnergyBeam.fromJson(json.getAsJsonObject())));
        }
        throw new JsonSyntaxException("Energy beam configuration must be either an object or array of multiple objects");
    }
}

