/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.energybeam;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.energybeam.EnergyBeamRenderer;
import net.threetag.palladium.client.renderer.LaserRenderer;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;
import net.threetag.palladium.util.PerspectiveValue;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.joml.Vector2f;

public class LightningBeamRenderer
extends EnergyBeamRenderer {
    private final LaserRenderer laserRenderer;
    private final int segments;
    private final int frequency;
    private final float spread;
    private final PerspectiveValue<Boolean> visibility;

    public LightningBeamRenderer(LaserRenderer laserRenderer, int segments, int frequency, float spread, PerspectiveValue<Boolean> visibility) {
        this.laserRenderer = laserRenderer;
        this.segments = segments;
        this.frequency = frequency;
        this.spread = spread;
        this.visibility = visibility;
    }

    @Override
    public void render(AbstractClientPlayer player, Vec3 origin, Vec3 target, float lengthMultiplier, PoseStack poseStack, MultiBufferSource bufferSource, int packedLightIn, boolean isFirstPerson, float partialTick) {
        if (this.visibility.getForPlayer((Player)player).booleanValue()) {
            Vector2f size = this.laserRenderer.getSize();
            float widthScale = SizeUtil.getInstance().getModelWidthScale((Entity)player, partialTick);
            float heightScale = SizeUtil.getInstance().getModelHeightScale((Entity)player, partialTick);
            this.laserRenderer.size(size.mul(widthScale, heightScale, new Vector2f()));
            Vec3 segmentPartVec = target.m_82546_(origin).m_82490_((double)(1.0f / (float)this.segments));
            RandomSource randomStart = RandomSource.m_216335_((long)(player.m_19879_() + player.f_19797_ / this.frequency));
            Vec3 startVec = origin;
            for (int i = 0; i < this.segments; ++i) {
                float currentProgress;
                float startProgress = 1.0f / (float)this.segments * (float)i;
                float endProgress = 1.0f / (float)this.segments * (float)(i + 1);
                float f = lengthMultiplier <= startProgress ? 0.0f : (currentProgress = lengthMultiplier >= endProgress ? 1.0f : (lengthMultiplier - startProgress) / (endProgress - startProgress));
                if (!(currentProgress > 0.0f)) continue;
                Vec3 end = i == this.segments - 1 ? target : origin.m_82549_(segmentPartVec.m_82490_((double)(i + 1))).m_82549_(LightningBeamRenderer.randomizeVector(randomStart, this.spread));
                Vec3 offset = startVec.m_82546_(origin);
                poseStack.m_85836_();
                poseStack.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
                this.laserRenderer.length((float)startVec.m_82554_(end) * currentProgress).faceAndRender(DataContext.forEntity((Entity)player), poseStack, bufferSource, startVec, end, player.f_19797_, partialTick);
                poseStack.m_85849_();
                startVec = end;
            }
            this.laserRenderer.size(size);
        }
    }

    private static Vec3 randomizeVector(RandomSource random, float spread) {
        return new Vec3((double)((random.m_188501_() - 0.5f) * 2.0f * spread), (double)((random.m_188501_() - 0.5f) * 2.0f * spread), (double)((random.m_188501_() - 0.5f) * 2.0f * spread));
    }

    public static class Serializer
    extends EnergyBeamRenderer.Serializer {
        public static final ResourceLocation ID = Palladium.id("lightning");

        @Override
        public EnergyBeamRenderer fromJson(JsonObject json) {
            return new LightningBeamRenderer(LaserRenderer.fromJson(json, 1), GsonUtil.getAsIntMin(json, "segments", 1, 5), GsonUtil.getAsIntMin(json, "frequency", 1, 2), GsonUtil.getAsFloatMin(json, "spread", 0.0f, 5.0f) / 16.0f, PerspectiveValue.getFromJson(json, "visibility", JsonElement::getAsBoolean, true));
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Lightning");
            builder.addProperty("segments", Integer.class).description("Determines how many split segments the lightning will have").fallback(5).exampleJson((JsonElement)new JsonPrimitive((Number)5));
            builder.addProperty("frequency", Integer.class).description("Determines how many ticks it takes for the beam to change its offset position").fallback(2).exampleJson((JsonElement)new JsonPrimitive((Number)2));
            builder.addProperty("spread", Float.class).description("Determines how far each offset segment-corner spreads from the center").fallback(Float.valueOf(5.0f)).exampleJson((JsonElement)new JsonPrimitive((Number)5));
            LaserRenderer.generateDocumentation(builder, 1, false);
            JsonObject exampleJson = new JsonObject();
            exampleJson.addProperty("first_person", Boolean.valueOf(true));
            exampleJson.addProperty("third_person", Boolean.valueOf(true));
            builder.addProperty("visibility", Boolean.class).description("Determines if its visible.").fallback(true).exampleJson((JsonElement)exampleJson);
        }

        @Override
        public ResourceLocation getId() {
            return ID;
        }
    }
}

