/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.model.animation;

import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.model.animation.PalladiumAnimation;
import net.threetag.palladium.entity.FlightHandler;
import net.threetag.palladium.entity.PalladiumPlayerExtension;
import net.threetag.palladium.util.Easing;
import net.threetag.palladiumcore.event.ViewportEvents;

@OnlyIn(value=Dist.CLIENT)
public class FlightAnimation
extends PalladiumAnimation
implements ViewportEvents.ComputeCameraAngles {
    public FlightAnimation(int priority) {
        super(priority);
        ViewportEvents.COMPUTE_CAMERA_ANGLES.register((Object)this);
    }

    @Override
    public void animate(PalladiumAnimation.Builder builder, AbstractClientPlayer player, HumanoidModel<?> model, PalladiumAnimation.FirstPersonContext firstPersonContext, float partialTicks) {
        boolean active;
        boolean bl = active = !firstPersonContext.firstPerson();
        if (active && player instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)player;
            FlightHandler flight = extension.palladium$getFlightHandler();
            float anim = flight.getFlightAnimation(partialTicks);
            if (anim <= 1.0f) {
                return;
            }
            anim = (anim - 1.0f) / 2.0f;
            Vec2 vec1 = FlightAnimation.to2D(flight.getFlightVector(partialTicks));
            Vec2 vec2 = FlightAnimation.to2D(flight.getLookAngle(partialTicks));
            double tilt = Mth.m_14008_((double)FlightAnimation.angleBetweenVector(vec1, vec2), (double)-0.5, (double)0.5) * 90.0 * (double)flight.getHorizontalSpeed(partialTicks);
            builder.get(PalladiumAnimation.PlayerModelPart.BODY).setZRotDegrees((float)(-tilt)).setXRotDegrees(-90.0f - player.m_146909_()).setY(3.2f).setY2(-14.4f).animate(Easing.INBACK, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.HEAD).setXRotDegrees(-90.0f).setYRotDegrees((float)tilt).animate(Easing.INBACK, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.CHEST).setXRotDegrees(-5.0f).setYRotDegrees(0.0f).setZRotDegrees(0.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).setXRotDegrees(0.0f).setYRotDegrees(17.5f).setZRotDegrees(5.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).setXRotDegrees(0.0f).setYRotDegrees(-17.5f).setZRotDegrees(-5.0f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_LEG).resetX().resetY().setZ(-1.0f).setXRotDegrees(5.0f).setYRotDegrees(2.5f).setZRotDegrees(2.5f).animate(Easing.INOUTCUBIC, anim);
            builder.get(PalladiumAnimation.PlayerModelPart.LEFT_LEG).resetX().resetY().setZ(-1.0f).setXRotDegrees(5.0f).setYRotDegrees(-2.5f).setZRotDegrees(-2.5f).animate(Easing.INOUTCUBIC, anim);
            if (FlightHandler.getAnimationType((LivingEntity)player) == FlightHandler.FlightAnimationType.HEROIC) {
                if (player.m_5737_() == HumanoidArm.RIGHT) {
                    builder.get(PalladiumAnimation.PlayerModelPart.RIGHT_ARM).setXRotDegrees(-180.0f).setYRotDegrees(0.0f).setZRotDegrees(-15.0f);
                } else {
                    builder.get(PalladiumAnimation.PlayerModelPart.LEFT_ARM).setXRotDegrees(-180.0f).setYRotDegrees(0.0f).setZRotDegrees(15.0f);
                }
            }
        }
    }

    public static Vec2 to2D(Vec3 vec) {
        return new Vec2((float)vec.f_82479_, (float)vec.f_82481_);
    }

    public static double angleBetweenVector(Vec2 vec1, Vec2 vec2) {
        return Math.atan2(vec1.f_82470_ * vec2.f_82471_ - vec1.f_82471_ * vec2.f_82470_, vec1.f_82470_ * vec2.f_82470_ + vec1.f_82471_ * vec2.f_82471_);
    }

    public void computeCameraAngles(GameRenderer gameRenderer, Camera camera, double partialTick, AtomicReference<Float> yaw, AtomicReference<Float> pitch, AtomicReference<Float> roll) {
        LocalPlayer localPlayer = Minecraft.m_91087_().f_91074_;
        if (localPlayer instanceof PalladiumPlayerExtension) {
            PalladiumPlayerExtension extension = (PalladiumPlayerExtension)localPlayer;
            FlightHandler flight = extension.palladium$getFlightHandler();
            float anim = flight.getFlightAnimation((float)partialTick);
            if (anim <= 1.0f) {
                return;
            }
            anim = (anim - 1.0f) / 2.0f;
            Vec2 vec1 = FlightAnimation.to2D(flight.getFlightVector((float)partialTick));
            Vec2 vec2 = FlightAnimation.to2D(flight.getLookAngle((float)partialTick));
            double tilt = Mth.m_14008_((double)FlightAnimation.angleBetweenVector(vec1, vec2), (double)-0.5, (double)0.5) * 30.0 * (double)flight.getHorizontalSpeed((float)partialTick);
            roll.set(Float.valueOf((float)tilt * Easing.INOUTCUBIC.apply(anim)));
        }
    }
}

