/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.item.armor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.renderer.renderlayer.ModelTypes;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;

public class ArmorModelData {
    private final Map<String, SkinTypedValue<ModelLayerLocation>> modelByKey = new HashMap<String, SkinTypedValue<ModelLayerLocation>>();
    private final Map<String, SkinTypedValue<HumanoidModel<?>>> generatedByKey = new HashMap();

    public ArmorModelData add(String key, SkinTypedValue<ModelLayerLocation> texture) {
        this.modelByKey.put(key, texture);
        return this;
    }

    @Nullable
    public HumanoidModel<?> get(String key, LivingEntity entity, boolean hasConditions) {
        if (!hasConditions) {
            SkinTypedValue<HumanoidModel<?>> fallback = this.generatedByKey.get("default");
            return fallback != null ? fallback.get((Entity)entity) : null;
        }
        SkinTypedValue<HumanoidModel<?>> data = this.generatedByKey.get(key);
        if (data == null) {
            throw new IllegalStateException("Unknown model key for armor: #" + key);
        }
        return data.get((Entity)entity);
    }

    public boolean has(String key) {
        return this.modelByKey.containsKey(key);
    }

    public void buildModels(ModelTypes.Model modelType, EntityModelSet modelSet) {
        this.modelByKey.forEach((key, layer) -> {
            HumanoidModel normal = (HumanoidModel)modelType.getModel(modelSet.m_171103_((ModelLayerLocation)layer.getNormal()));
            if (((ModelLayerLocation)layer.getNormal()).equals(layer.getSlim())) {
                this.generatedByKey.put((String)key, (SkinTypedValue<HumanoidModel<?>>)new SkinTypedValue<HumanoidModel>(normal));
            } else {
                HumanoidModel slim = (HumanoidModel)modelType.getModel(modelSet.m_171103_((ModelLayerLocation)layer.getSlim()));
                this.generatedByKey.put((String)key, (SkinTypedValue<HumanoidModel<?>>)new SkinTypedValue<HumanoidModel>(normal, slim));
            }
        });
    }

    public static ArmorModelData fromJson(JsonElement json) {
        ArmorModelData data = new ArmorModelData();
        if (json == null) {
            return data.add("default", new SkinTypedValue<ModelLayerLocation>(ModelLayers.f_171261_));
        }
        if (json.isJsonPrimitive() || json.isJsonObject() && json.getAsJsonObject().entrySet().size() == 2 && GsonHelper.m_13900_((JsonObject)json.getAsJsonObject(), (String)"normal") && GsonHelper.m_13900_((JsonObject)json.getAsJsonObject(), (String)"slim")) {
            SkinTypedValue<ModelLayerLocation> texture = SkinTypedValue.fromJSON(json, j -> GsonUtil.convertToModelLayerLocation(j, "model_layers"));
            data.add("default", texture);
        } else if (json.isJsonObject()) {
            JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"model_layers");
            for (Map.Entry e : object.entrySet()) {
                String key = (String)e.getKey();
                JsonElement textureJson = (JsonElement)e.getValue();
                data.add(key, SkinTypedValue.fromJSON(textureJson, j -> GsonUtil.convertToModelLayerLocation(j, "model_layers")));
            }
        } else {
            throw new JsonParseException("Model layers must be json primitive or json object");
        }
        return data;
    }
}

