/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.item.armor;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererData;
import net.threetag.palladium.compat.geckolib.GeckoLibCompat;
import net.threetag.palladium.item.ArmorWithRenderer;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladiumcore.util.Platform;

public class ArmorRendererManager
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final List<ArmorWithRenderer> EXTENDED_ARMOR_ITEMS = new ArrayList<ArmorWithRenderer>();
    public static final Map<ArmorWithRenderer, ArmorRendererData> LEGACY_SUPPORT = new HashMap<ArmorWithRenderer, ArmorRendererData>();
    private static boolean LOOK_FOR_ITEMS = false;
    public static ArmorRendererManager INSTANCE;
    public Map<ResourceLocation, ArmorRendererData> byName = ImmutableMap.of();

    public ArmorRendererManager() {
        super(GSON, "palladium/armor_renderers");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> object, ResourceManager resourceManager, ProfilerFiller profiler) {
        if (!LOOK_FOR_ITEMS) {
            for (Item item : BuiltInRegistries.f_257033_) {
                if (!(item instanceof ArmorWithRenderer)) continue;
                ArmorWithRenderer armor = (ArmorWithRenderer)item;
                EXTENDED_ARMOR_ITEMS.add(armor);
            }
            LOOK_FOR_ITEMS = true;
        }
        EXTENDED_ARMOR_ITEMS.forEach(i -> i.setCachedArmorRenderer(null));
        EntityModelSet entityModelSet = Minecraft.m_91087_().m_167973_();
        ImmutableMap.Builder builder = ImmutableMap.builder();
        object.forEach((id, json) -> {
            try {
                ArmorRendererData data = ArmorRendererData.fromJson(GsonHelper.m_13918_((JsonElement)json, (String)"$"));
                data.buildModels(entityModelSet);
                builder.put(id, (Object)data);
            }
            catch (Exception e) {
                AddonPackLog.error("Parsing error loading armor renderer {}", id, e);
            }
        });
        this.byName = builder.build();
        EXTENDED_ARMOR_ITEMS.forEach(i -> {
            ArmorRendererData renderer = this.byName.get(i.getArmorRendererFile());
            ArmorRendererData legacyRenderer = LEGACY_SUPPORT.get(i);
            if (renderer == null && legacyRenderer == null) {
                i.setCachedArmorRenderer(null);
            } else if (renderer != null && legacyRenderer == null) {
                i.setCachedArmorRenderer(renderer);
            } else {
                i.setCachedArmorRenderer(Objects.requireNonNullElse(renderer, legacyRenderer));
            }
        });
        AddonPackLog.info("Loaded {} armor renderers", this.byName.size());
    }

    public static void renderFirstPerson(AbstractClientPlayer player, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, ModelPart rendererArm, boolean rightArm) {
        ArmorWithRenderer item;
        Object object;
        ItemStack stack = player.m_6844_(EquipmentSlot.CHEST);
        if (!stack.m_41619_() && (object = stack.m_41720_()) instanceof ArmorWithRenderer && (object = (item = (ArmorWithRenderer)object).getCachedArmorRenderer()) instanceof ArmorRendererData) {
            ArmorRendererData renderer = (ArmorRendererData)object;
            DataContext context = DataContext.forArmorInSlot((LivingEntity)player, EquipmentSlot.CHEST);
            HumanoidModel<?> armorModel = renderer.getModel((LivingEntity)player, context);
            VertexConsumer vertex = ItemRenderer.m_115184_((MultiBufferSource)buffer, (RenderType)PalladiumRenderTypes.getArmorTranslucent(renderer.getTexture(context)), (boolean)false, (boolean)stack.m_41790_());
            ModelPart arm = rightArm ? armorModel.f_102811_ : armorModel.f_102812_;
            arm.m_104315_(rendererArm);
            arm.f_104203_ = 0.0f;
            arm.m_104301_(poseStack, vertex, combinedLight, OverlayTexture.f_118083_);
            if (armorModel instanceof PlayerModel) {
                PlayerModel playerModel = (PlayerModel)armorModel;
                arm = rightArm ? playerModel.f_103375_ : playerModel.f_103374_;
                arm.m_104315_(rendererArm);
                arm.f_104203_ = 0.0f;
                arm.m_104301_(poseStack, vertex, combinedLight, OverlayTexture.f_118083_);
            }
        }
        if (!stack.m_41619_() && Platform.isModLoaded((String)"geckolib")) {
            GeckoLibCompat.renderFirstPerson(player, stack, poseStack, buffer, combinedLight, rendererArm, rightArm);
        }
    }
}

