/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.item.armor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.NotNull;

public class ArmorTextureData {
    private final Map<String, SkinTypedValue<DynamicTexture>> textureByKey = new HashMap<String, SkinTypedValue<DynamicTexture>>();

    public ArmorTextureData add(String key, SkinTypedValue<DynamicTexture> texture) {
        this.textureByKey.put(key, texture);
        return this;
    }

    @NotNull
    public ResourceLocation get(String key, DataContext context) {
        SkinTypedValue<DynamicTexture> data = this.textureByKey.get(key);
        if (data == null) {
            throw new IllegalStateException("Unknown texture key for armor: #" + key);
        }
        return data.get(context.getEntity()).getTexture(context);
    }

    public boolean has(String key) {
        return this.textureByKey.containsKey(key);
    }

    public static ArmorTextureData fromJson(JsonElement json) {
        ArmorTextureData data = new ArmorTextureData();
        if (json.isJsonPrimitive() || json.isJsonObject() && json.getAsJsonObject().entrySet().size() == 2 && GsonHelper.m_13900_((JsonObject)json.getAsJsonObject(), (String)"normal") && GsonHelper.m_13900_((JsonObject)json.getAsJsonObject(), (String)"slim")) {
            SkinTypedValue<DynamicTexture> texture = SkinTypedValue.fromJSON(json, DynamicTextureManager::fromJson);
            data.add("default", texture);
        } else if (json.isJsonObject()) {
            JsonObject object = GsonHelper.m_13918_((JsonElement)json, (String)"textures");
            for (Map.Entry e : object.entrySet()) {
                String key = (String)e.getKey();
                JsonElement textureJson = (JsonElement)e.getValue();
                data.add(key, SkinTypedValue.fromJSON(textureJson, DynamicTextureManager::fromJson));
            }
        } else {
            throw new JsonParseException("Textures must be json primitive or json object");
        }
        return data;
    }
}

