/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.minecraft.client.model.AxolotlModel;
import net.minecraft.client.model.BatModel;
import net.minecraft.client.model.BeeModel;
import net.minecraft.client.model.BlazeModel;
import net.minecraft.client.model.CamelModel;
import net.minecraft.client.model.CatModel;
import net.minecraft.client.model.ChickenModel;
import net.minecraft.client.model.CodModel;
import net.minecraft.client.model.CowModel;
import net.minecraft.client.model.CreeperModel;
import net.minecraft.client.model.DolphinModel;
import net.minecraft.client.model.EndermanModel;
import net.minecraft.client.model.EndermiteModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.FoxModel;
import net.minecraft.client.model.FrogModel;
import net.minecraft.client.model.GhastModel;
import net.minecraft.client.model.GoatModel;
import net.minecraft.client.model.GuardianModel;
import net.minecraft.client.model.HoglinModel;
import net.minecraft.client.model.HorseModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.IllagerModel;
import net.minecraft.client.model.IronGolemModel;
import net.minecraft.client.model.LavaSlimeModel;
import net.minecraft.client.model.LlamaModel;
import net.minecraft.client.model.PandaModel;
import net.minecraft.client.model.ParrotModel;
import net.minecraft.client.model.PhantomModel;
import net.minecraft.client.model.PigModel;
import net.minecraft.client.model.PiglinModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.PolarBearModel;
import net.minecraft.client.model.RabbitModel;
import net.minecraft.client.model.RavagerModel;
import net.minecraft.client.model.SalmonModel;
import net.minecraft.client.model.SheepModel;
import net.minecraft.client.model.ShulkerModel;
import net.minecraft.client.model.SilverfishModel;
import net.minecraft.client.model.SlimeModel;
import net.minecraft.client.model.SnowGolemModel;
import net.minecraft.client.model.SpiderModel;
import net.minecraft.client.model.SquidModel;
import net.minecraft.client.model.StriderModel;
import net.minecraft.client.model.TurtleModel;
import net.minecraft.client.model.VexModel;
import net.minecraft.client.model.VillagerModel;
import net.minecraft.client.model.WitherBossModel;
import net.minecraft.client.model.WolfModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.model.BasicModel;
import net.threetag.palladium.client.model.CapedHumanoidModel;
import net.threetag.palladium.client.model.ImprovedHumanoidModel;
import net.threetag.palladium.client.model.ThrusterHumanoidModel;

public class ModelTypes {
    private static final Map<ResourceLocation, Model> MODELS = new HashMap<ResourceLocation, Model>();
    public static final Model HUMANOID;

    public static Model register(ResourceLocation id, Model model) {
        MODELS.put(id, model);
        return model;
    }

    public static Model get(ResourceLocation id) {
        return MODELS.get(id);
    }

    static {
        ModelTypes.register(Palladium.id("basic"), new Model(BasicModel::new, (en, model) -> true));
        HUMANOID = ModelTypes.register(new ResourceLocation("humanoid"), new Model(ImprovedHumanoidModel::new, (en, model) -> model instanceof HumanoidModel));
        ModelTypes.register(new ResourceLocation("player"), new Model(modelPart -> new PlayerModel(modelPart, false), (en, model) -> model instanceof HumanoidModel));
        ModelTypes.register(new ResourceLocation("pig"), new Model(PigModel::new, (en, model) -> model instanceof PigModel));
        ModelTypes.register(new ResourceLocation("wolf"), new Model(WolfModel::new, (en, model) -> model instanceof WolfModel));
        ModelTypes.register(new ResourceLocation("cat"), new Model(CatModel::new, (en, model) -> model instanceof CatModel));
        ModelTypes.register(new ResourceLocation("horse"), new Model(HorseModel::new, (en, model) -> model instanceof HorseModel));
        ModelTypes.register(new ResourceLocation("sheep"), new Model(SheepModel::new, (en, model) -> model instanceof SheepModel));
        ModelTypes.register(new ResourceLocation("cow"), new Model(CowModel::new, (en, model) -> model instanceof CowModel));
        ModelTypes.register(new ResourceLocation("chicken"), new Model(ChickenModel::new, (en, model) -> model instanceof ChickenModel));
        ModelTypes.register(new ResourceLocation("villager"), new Model(VillagerModel::new, (en, model) -> model instanceof VillagerModel));
        ModelTypes.register(new ResourceLocation("illager"), new Model(IllagerModel::new, (en, model) -> model instanceof IllagerModel));
        ModelTypes.register(new ResourceLocation("axolotl"), new Model(AxolotlModel::new, (en, model) -> model instanceof AxolotlModel));
        ModelTypes.register(new ResourceLocation("bat"), new Model(BatModel::new, (en, model) -> model instanceof BatModel));
        ModelTypes.register(new ResourceLocation("bee"), new Model(BeeModel::new, (en, model) -> model instanceof BeeModel));
        ModelTypes.register(new ResourceLocation("blaze"), new Model(BlazeModel::new, (en, model) -> model instanceof BlazeModel));
        ModelTypes.register(new ResourceLocation("spider"), new Model(SpiderModel::new, (en, model) -> model instanceof SpiderModel));
        ModelTypes.register(new ResourceLocation("cod"), new Model(CodModel::new, (en, model) -> model instanceof CodModel));
        ModelTypes.register(new ResourceLocation("creeper"), new Model(CreeperModel::new, (en, model) -> model instanceof CreeperModel));
        ModelTypes.register(new ResourceLocation("dolphin"), new Model(DolphinModel::new, (en, model) -> model instanceof DolphinModel));
        ModelTypes.register(new ResourceLocation("guardian"), new Model(GuardianModel::new, (en, model) -> model instanceof GuardianModel));
        ModelTypes.register(new ResourceLocation("enderman"), new Model(EndermanModel::new, (en, model) -> model instanceof EndermanModel));
        ModelTypes.register(new ResourceLocation("endermite"), new Model(EndermiteModel::new, (en, model) -> model instanceof EndermiteModel));
        ModelTypes.register(new ResourceLocation("fox"), new Model(FoxModel::new, (en, model) -> model instanceof FoxModel));
        ModelTypes.register(new ResourceLocation("ghast"), new Model(GhastModel::new, (en, model) -> model instanceof GhastModel));
        ModelTypes.register(new ResourceLocation("goat"), new Model(GoatModel::new, (en, model) -> model instanceof GoatModel));
        ModelTypes.register(new ResourceLocation("hoglin"), new Model(HoglinModel::new, (en, model) -> model instanceof HoglinModel));
        ModelTypes.register(new ResourceLocation("iron_golem"), new Model(IronGolemModel::new, (en, model) -> model instanceof IronGolemModel));
        ModelTypes.register(new ResourceLocation("llama"), new Model(LlamaModel::new, (en, model) -> model instanceof LlamaModel));
        ModelTypes.register(new ResourceLocation("magma_cube"), new Model(LavaSlimeModel::new, (en, model) -> model instanceof LavaSlimeModel));
        ModelTypes.register(new ResourceLocation("panda"), new Model(PandaModel::new, (en, model) -> model instanceof PandaModel));
        ModelTypes.register(new ResourceLocation("parrot"), new Model(ParrotModel::new, (en, model) -> model instanceof ParrotModel));
        ModelTypes.register(new ResourceLocation("phantom"), new Model(PhantomModel::new, (en, model) -> model instanceof PhantomModel));
        ModelTypes.register(new ResourceLocation("piglin"), new Model(PiglinModel::new, (en, model) -> model instanceof PiglinModel));
        ModelTypes.register(new ResourceLocation("polar_bear"), new Model(PolarBearModel::new, (en, model) -> model instanceof PolarBearModel));
        ModelTypes.register(new ResourceLocation("rabbit"), new Model(RabbitModel::new, (en, model) -> model instanceof RabbitModel));
        ModelTypes.register(new ResourceLocation("ravager"), new Model(RavagerModel::new, (en, model) -> model instanceof RavagerModel));
        ModelTypes.register(new ResourceLocation("salmon"), new Model(SalmonModel::new, (en, model) -> model instanceof SalmonModel));
        ModelTypes.register(new ResourceLocation("shulker"), new Model(ShulkerModel::new, (en, model) -> model instanceof ShulkerModel));
        ModelTypes.register(new ResourceLocation("silverfish"), new Model(SilverfishModel::new, (en, model) -> model instanceof SilverfishModel));
        ModelTypes.register(new ResourceLocation("slime"), new Model(SlimeModel::new, (en, model) -> model instanceof SlimeModel));
        ModelTypes.register(new ResourceLocation("snow_golem"), new Model(SnowGolemModel::new, (en, model) -> model instanceof SnowGolemModel));
        ModelTypes.register(new ResourceLocation("squid"), new Model(SquidModel::new, (en, model) -> model instanceof SquidModel));
        ModelTypes.register(new ResourceLocation("strider"), new Model(StriderModel::new, (en, model) -> model instanceof StriderModel));
        ModelTypes.register(new ResourceLocation("turtle"), new Model(TurtleModel::new, (en, model) -> model instanceof TurtleModel));
        ModelTypes.register(new ResourceLocation("vex"), new Model(VexModel::new, (en, model) -> model instanceof VexModel));
        ModelTypes.register(new ResourceLocation("wither"), new Model(WitherBossModel::new, (en, model) -> model instanceof WitherBossModel));
        ModelTypes.register(new ResourceLocation("camel"), new Model(CamelModel::new, (en, model) -> model instanceof CamelModel));
        ModelTypes.register(new ResourceLocation("frog"), new Model(FrogModel::new, (en, model) -> model instanceof FrogModel));
        ModelTypes.register(Palladium.id("caped_humanoid"), new Model(CapedHumanoidModel::new, (en, model) -> model instanceof HumanoidModel));
        ModelTypes.register(Palladium.id("thruster_humanoid"), new Model(ThrusterHumanoidModel::new, (en, model) -> model instanceof HumanoidModel));
    }

    public record Model(Function<ModelPart, EntityModel<?>> modelFunction, BiPredicate<Entity, EntityModel<?>> predicate) {
        public EntityModel<?> getModel(ModelPart modelPart) {
            return this.modelFunction.apply(modelPart);
        }

        public boolean fitsEntity(Entity entity, EntityModel<?> parentModel) {
            return this.predicate.test(entity, parentModel);
        }
    }
}

