/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.renderer.renderlayer.CompoundPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import org.jetbrains.annotations.Nullable;

public class RenderLayerStates {
    private final Map<IPackRenderLayer, State> map = new HashMap<IPackRenderLayer, State>();

    public void tick(LivingEntity entity) {
        ArrayList layers = new ArrayList();
        PackRenderLayerManager.forEachLayer((Entity)entity, (context, layer) -> {
            layers.add(layer);
            if (layer instanceof CompoundPackRenderLayer) {
                CompoundPackRenderLayer com = (CompoundPackRenderLayer)layer;
                layers.addAll(com.layers());
            }
        });
        ArrayList<IPackRenderLayer> toRemove = new ArrayList<IPackRenderLayer>();
        for (IPackRenderLayer layer2 : this.map.keySet()) {
            boolean found = false;
            for (IPackRenderLayer checkedLayer : layers) {
                if (!checkedLayer.isOrContains(layer2)) continue;
                found = true;
                break;
            }
            if (found) continue;
            toRemove.add(layer2);
        }
        for (IPackRenderLayer layer2 : toRemove) {
            this.map.remove(layer2);
        }
        for (State state : this.map.values()) {
            state.tick(entity);
        }
    }

    @Nullable
    public State get(IPackRenderLayer layer) {
        return this.map.get(layer);
    }

    @Nullable
    public State getOrCreate(IPackRenderLayer layer) {
        if (this.map.containsKey(layer)) {
            return this.map.get(layer);
        }
        State state = layer.createState();
        return this.map.computeIfAbsent(layer, l -> state);
    }

    public static class State {
        public int ticks;

        public void tick(LivingEntity entity) {
            ++this.ticks;
        }
    }
}

