/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.renderlayer;

import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.model.ThrusterHumanoidModel;
import net.threetag.palladium.client.renderer.DynamicColor;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;

public class ThrusterPackRenderLayer
extends AbstractPackRenderLayer {
    public static final ModelLayerLocation MODEL_LAYER_LOCATION = new ModelLayerLocation(Palladium.id("humanoid"), "thrusters");
    public static final ModelLayerLocation MODEL_LAYER_LOCATION_SLIM = new ModelLayerLocation(Palladium.id("humanoid"), "thrusters_slim");
    public static final ResourceLocation[] TEXTURES = new ResourceLocation[8];
    private static final DynamicColor DEFAULT_COLOR = DynamicColor.staticColor(new Color(234, 182, 43));
    private final SkinTypedValue<ThrusterHumanoidModel<?>> model = new SkinTypedValue(new ThrusterHumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(MODEL_LAYER_LOCATION)), new ThrusterHumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(MODEL_LAYER_LOCATION_SLIM)));
    private final boolean rightArm;
    private final boolean leftArm;
    private final boolean rightLeg;
    private final boolean leftLeg;
    private final DynamicColor color;

    public ThrusterPackRenderLayer(boolean rightArm, boolean leftArm, boolean rightLeg, boolean leftLeg, DynamicColor color) {
        this.rightArm = rightArm;
        this.leftArm = leftArm;
        this.rightLeg = rightLeg;
        this.leftLeg = leftLeg;
        this.color = color;
    }

    @Override
    public void render(DataContext context, PoseStack poseStack, MultiBufferSource bufferSource, EntityModel<Entity> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity entity = context.getLivingEntity();
        if (entity != null && IPackRenderLayer.conditionsFulfilled((Entity)entity, this.conditions, this.thirdPersonConditions)) {
            ThrusterHumanoidModel<?> model = this.model.get((Entity)entity);
            if (parentModel instanceof HumanoidModel) {
                HumanoidModel parentHumanoid = (HumanoidModel)parentModel;
                IPackRenderLayer.copyModelProperties((Entity)entity, parentHumanoid, model);
            }
            model.extraAnimations(entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, partialTicks);
            model.rightArmThruster.f_104207_ = this.rightArm;
            model.leftArmThruster.f_104207_ = this.leftArm;
            model.rightLegThruster.f_104207_ = this.rightLeg;
            model.leftLegThruster.f_104207_ = this.leftLeg;
            VertexConsumer vertexConsumer = bufferSource.m_6299_(PalladiumRenderTypes.getGlowing(TEXTURES[entity.f_19797_ / 2 % TEXTURES.length]));
            Color color = this.color.getColor(context);
            model.m_7695_(poseStack, vertexConsumer, 0xF00000, OverlayTexture.f_118083_, (float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, (float)color.getAlpha() / 255.0f);
        }
    }

    @Override
    public void renderArm(DataContext context, HumanoidArm arm, PlayerRenderer playerRenderer, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.renderArm(context, arm, playerRenderer, poseStack, bufferSource, packedLight);
    }

    public static ThrusterPackRenderLayer parse(JsonObject json) {
        return new ThrusterPackRenderLayer(GsonHelper.m_13855_((JsonObject)json, (String)"right_arm", (boolean)true), GsonHelper.m_13855_((JsonObject)json, (String)"left_arm", (boolean)true), GsonHelper.m_13855_((JsonObject)json, (String)"right_leg", (boolean)true), GsonHelper.m_13855_((JsonObject)json, (String)"left_leg", (boolean)true), DynamicColor.getFromJson(json, "color", DEFAULT_COLOR));
    }

    static {
        for (int i = 0; i < TEXTURES.length; ++i) {
            ThrusterPackRenderLayer.TEXTURES[i] = Palladium.id("textures/models/thruster/" + i + ".png");
        }
    }
}

