/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.client.renderer.trail;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.client.renderer.trail.TrailRenderer;
import net.threetag.palladium.client.renderer.trail.TrailRendererManager;
import net.threetag.palladium.documentation.JsonDocumentationBuilder;

public class CompoundTrailRenderer
extends TrailRenderer {
    private final List<TrailRenderer<?>> trailRenderers;

    public CompoundTrailRenderer(List<TrailRenderer<?>> trailRenderers) {
        this.trailRenderers = trailRenderers;
    }

    public List<TrailRenderer<?>> getTrailRenderers() {
        return this.trailRenderers;
    }

    @Override
    public float getSpacing() {
        throw new AssertionError();
    }

    @Override
    public int getLifetime() {
        throw new AssertionError();
    }

    public static class Serializer
    implements TrailRendererManager.TypeSerializer {
        @Override
        public TrailRenderer<?> parse(JsonObject json) {
            JsonArray trailsElement = GsonHelper.m_13933_((JsonObject)json, (String)"trails");
            ArrayList trails = new ArrayList();
            for (JsonElement element : trailsElement) {
                trails.add(TrailRendererManager.fromJson(GsonHelper.m_13918_((JsonElement)element, (String)"trails[].$")));
            }
            return new CompoundTrailRenderer(trails);
        }

        @Override
        public void generateDocumentation(JsonDocumentationBuilder builder) {
            builder.setTitle("Compound");
            builder.setDescription("Can be used to merge multiple trails into one file.");
            builder.addProperty("trails", TrailRenderer[].class).description("Can be used to merge multiple trails into one file. Simply declare them in this array").exampleJson((JsonElement)new JsonArray());
        }

        @Override
        public ResourceLocation getId() {
            return Palladium.id("compound");
        }
    }
}

