/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.command;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.power.SuperpowerUtil;
import net.threetag.palladium.util.property.PalladiumProperties;
import net.threetag.palladiumcore.util.Platform;

public class SuperpowerCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_POWERS = (context, builder) -> {
        Collection<Power> powers = PowerManager.getInstance((Level)Objects.requireNonNull(Platform.getCurrentServer()).m_129783_()).getPowers();
        return SharedSuggestionProvider.m_82957_(powers.stream().map(Power::getId), (SuggestionsBuilder)builder);
    };
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_OWN_POWERS_ALL = (context, builder) -> {
        Collection<Object> entities;
        ArrayList superpowers = Lists.newArrayList();
        try {
            context.getArgument("entities", EntitySelector.class);
            entities = EntityArgument.m_91461_((CommandContext)context, (String)"entities");
        }
        catch (Exception e) {
            entities = Collections.singleton(((CommandSourceStack)context.getSource()).m_81375_());
        }
        for (Entity entity : entities) {
            for (ResourceLocation id : PalladiumProperties.SUPERPOWER_IDS.get(entity)) {
                ResourceLocation allId = new ResourceLocation(id.m_135827_(), "all");
                if (!superpowers.contains(allId)) {
                    superpowers.add(allId);
                }
                if (superpowers.contains(id)) continue;
                superpowers.add(id);
            }
        }
        return SharedSuggestionProvider.m_82926_((Iterable)superpowers, (SuggestionsBuilder)builder);
    };
    public static final DynamicCommandExceptionType POWER_NOT_FOUND = new DynamicCommandExceptionType(object -> Component.m_237110_((String)"commands.superpower.error.powerNotFound", (Object[])new Object[]{object}));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"superpower").requires(player -> player.m_6761_(2))).then(Commands.m_82127_((String)"query").then(Commands.m_82129_((String)"entity", (ArgumentType)EntityArgument.m_91449_()).executes(c -> SuperpowerCommand.querySuperpowers((CommandSourceStack)c.getSource(), EntityArgument.m_91452_((CommandContext)c, (String)"entity")))))).then(Commands.m_82127_((String)"set").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.setSuperpower((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "power")))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> SuperpowerCommand.setSuperpower((CommandSourceStack)c.getSource(), EntityArgument.m_91461_((CommandContext)c, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "power"))))))).then(Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.addSuperpower((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "power")))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> SuperpowerCommand.addSuperpower((CommandSourceStack)c.getSource(), EntityArgument.m_91461_((CommandContext)c, (String)"entities"), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "power"))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"remove").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS_ALL).executes(c -> SuperpowerCommand.removeSuperpower((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"power").toString()))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> SuperpowerCommand.removeSuperpower((CommandSourceStack)c.getSource(), EntityArgument.m_91461_((CommandContext)c, (String)"entities"), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"power").toString()))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"*").executes(c -> SuperpowerCommand.removeSuperpower((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), "all"))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> SuperpowerCommand.removeSuperpower((CommandSourceStack)c.getSource(), EntityArgument.m_91461_((CommandContext)c, (String)"entities"), "all"))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"all").executes(c -> SuperpowerCommand.removeSuperpower((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), "all"))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> SuperpowerCommand.removeSuperpower((CommandSourceStack)c.getSource(), EntityArgument.m_91461_((CommandContext)c, (String)"entities"), "all")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"replace").then(Commands.m_82129_((String)"replaced_power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_OWN_POWERS_ALL).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"replacing_power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.replaceSuperpower((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"replaced_power").toString(), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "replacing_power")))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> SuperpowerCommand.replaceSuperpower((CommandSourceStack)c.getSource(), EntityArgument.m_91461_((CommandContext)c, (String)"entities"), ResourceLocationArgument.m_107011_((CommandContext)c, (String)"replaced_power").toString(), SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "replacing_power"))))))).then(Commands.m_82127_((String)"*").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"replacing_power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.replaceSuperpower((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), "all", SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "replacing_power")))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> SuperpowerCommand.replaceSuperpower((CommandSourceStack)c.getSource(), EntityArgument.m_91461_((CommandContext)c, (String)"entities"), "all", SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "replacing_power"))))))).then(Commands.m_82127_((String)"all").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"replacing_power", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_POWERS).executes(c -> SuperpowerCommand.replaceSuperpower((CommandSourceStack)c.getSource(), Collections.singleton(((CommandSourceStack)c.getSource()).m_81375_()), "all", SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "replacing_power")))).then(Commands.m_82129_((String)"entities", (ArgumentType)EntityArgument.m_91460_()).executes(c -> SuperpowerCommand.replaceSuperpower((CommandSourceStack)c.getSource(), EntityArgument.m_91461_((CommandContext)c, (String)"entities"), "all", SuperpowerCommand.getSuperpower((CommandContext<CommandSourceStack>)c, "replacing_power"))))))));
    }

    private static int querySuperpowers(CommandSourceStack source, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            StringBuilder result = new StringBuilder();
            int i = 0;
            for (ResourceLocation id : SuperpowerUtil.getSuperpowerIds(livingEntity)) {
                result.append(id.toString()).append(", ");
                ++i;
            }
            if (i == 0) {
                source.m_81352_((Component)Component.m_237110_((String)"commands.superpower.error.noSuperpowers", (Object[])new Object[]{livingEntity.m_5446_()}));
            } else {
                source.m_288197_(() -> Component.m_237110_((String)"commands.superpower.query.success", (Object[])new Object[]{livingEntity.m_5446_(), result.substring(0, result.length() - 3)}), true);
            }
            return i;
        }
        source.m_81352_((Component)Component.m_237115_((String)"commands.superpower.error.noLivingEntity"));
        return 0;
    }

    public static Power getSuperpower(CommandContext<CommandSourceStack> context, String key) throws CommandSyntaxException {
        ResourceLocation resourceLocation = (ResourceLocation)context.getArgument(key, ResourceLocation.class);
        Power power = PowerManager.getInstance((Level)((CommandSourceStack)context.getSource()).m_81372_()).getPower(resourceLocation);
        if (power == null) {
            throw POWER_NOT_FOUND.create((Object)resourceLocation);
        }
        return power;
    }

    public static int setSuperpower(CommandSourceStack commandSource, Collection<? extends Entity> entities, Power power) {
        Iterator<? extends Entity> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                SuperpowerUtil.setSuperpower(livingEntity, power);
                ++i;
                continue;
            }
            commandSource.m_81352_((Component)Component.m_237115_((String)"commands.superpower.error.noLivingEntity"));
        }
        if (i == 1) {
            commandSource.m_288197_(() -> Component.m_237110_((String)"commands.superpower.success.entity.single", (Object[])new Object[]{((Entity)entities.iterator().next()).m_5446_(), power.getName()}), true);
        } else {
            int finalI = i;
            commandSource.m_288197_(() -> Component.m_237110_((String)"commands.superpower.success.entity.multiple", (Object[])new Object[]{finalI, power.getName()}), true);
        }
        return i;
    }

    public static int addSuperpower(CommandSourceStack commandSource, Collection<? extends Entity> entities, Power superpower) {
        Iterator<? extends Entity> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (SuperpowerUtil.addSuperpower(livingEntity, superpower)) {
                    ++i;
                    continue;
                }
                if (entities.size() != 1) continue;
                no = true;
                commandSource.m_81352_((Component)Component.m_237110_((String)"commands.superpower.error.alreadyHasSuperpower", (Object[])new Object[]{entity.m_5446_()}));
                continue;
            }
            commandSource.m_81352_((Component)Component.m_237115_((String)"commands.superpower.error.noLivingEntity"));
        }
        if (!no) {
            if (i == 1) {
                commandSource.m_288197_(() -> Component.m_237110_((String)"commands.superpower.success.entity.single", (Object[])new Object[]{((Entity)entities.iterator().next()).m_5446_(), superpower.getName()}), true);
            } else {
                int finalI = i;
                commandSource.m_288197_(() -> Component.m_237110_((String)"commands.superpower.success.entity.multiple", (Object[])new Object[]{finalI, superpower.getName()}), true);
            }
        }
        return i;
    }

    public static int removeSuperpower(CommandSourceStack commandSource, Collection<? extends Entity> entities, String filter) {
        Predicate<ResourceLocation> predicate;
        Iterator<? extends Entity> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        Predicate<ResourceLocation> predicate2 = filter.equalsIgnoreCase("all") ? id -> true : (predicate = filter.endsWith(":all") ? id -> id.m_135827_().equals(filter.split(":")[0]) : id -> id.equals((Object)new ResourceLocation(filter)));
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (SuperpowerUtil.removeSuperpowersByIds(livingEntity, predicate) > 0) {
                    ++i;
                    continue;
                }
                if (entities.size() != 1) continue;
                no = true;
                commandSource.m_81352_((Component)Component.m_237110_((String)"commands.superpower.error.doesntHaveSuperpower", (Object[])new Object[]{entity.m_5446_()}));
                continue;
            }
            commandSource.m_81352_((Component)Component.m_237115_((String)"commands.superpower.error.noLivingEntity"));
        }
        if (!no) {
            if (i == 1) {
                commandSource.m_288197_(() -> Component.m_237110_((String)"commands.superpower.remove.success.entity.single", (Object[])new Object[]{((Entity)entities.iterator().next()).m_5446_()}), true);
            } else {
                int finalI = i;
                commandSource.m_288197_(() -> Component.m_237110_((String)"commands.superpower.remove.success.entity.multiple", (Object[])new Object[]{finalI}), true);
            }
        }
        return i;
    }

    public static int replaceSuperpower(CommandSourceStack commandSource, Collection<? extends Entity> entities, String replacedFilter, Power replacingPower) {
        Predicate<ResourceLocation> predicate;
        Iterator<? extends Entity> iterator = entities.iterator();
        int i = 0;
        boolean no = false;
        Predicate<ResourceLocation> predicate2 = replacedFilter.equalsIgnoreCase("all") ? id -> true : (predicate = replacedFilter.endsWith(":all") ? id -> id.m_135827_().equals(replacedFilter.split(":")[0]) : id -> id.equals((Object)new ResourceLocation(replacedFilter)));
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                if (SuperpowerUtil.removeSuperpowersByIds(livingEntity, predicate) > 0 && SuperpowerUtil.addSuperpower(livingEntity, replacingPower)) {
                    ++i;
                    continue;
                }
                if (entities.size() != 1) continue;
                no = true;
                commandSource.m_81352_((Component)Component.m_237110_((String)"commands.superpower.error.doesntHaveSuperpower", (Object[])new Object[]{entity.m_5446_()}));
                continue;
            }
            commandSource.m_81352_((Component)Component.m_237115_((String)"commands.superpower.error.noLivingEntity"));
        }
        if (!no) {
            if (i == 1) {
                commandSource.m_288197_(() -> Component.m_237110_((String)"commands.superpower.replace.success.entity.single", (Object[])new Object[]{((Entity)entities.iterator().next()).m_5446_()}), true);
            } else {
                int finalI = i;
                commandSource.m_288197_(() -> Component.m_237110_((String)"commands.superpower.replace.success.entity.multiple", (Object[])new Object[]{finalI}), true);
            }
        }
        return i;
    }
}

