/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.armor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.renderer.PalladiumRenderTypes;
import net.threetag.palladium.compat.geckolib.armor.AddonGeoArmorItem;
import net.threetag.palladium.compat.geckolib.armor.CancelGeckoArmorBuffer;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.renderer.GeoArmorRenderer;

public class GeckoArmorRenderer<T extends AddonGeoArmorItem>
extends GeoArmorRenderer<T>
implements CancelGeckoArmorBuffer {
    private static Entity CURRENT_ENTITY = null;
    private static EquipmentSlot CURRENT_SLOT = null;

    public GeckoArmorRenderer(AddonGeoArmorItem item) {
        super(GeckoArmorRenderer.createGeoModel(item));
    }

    public static <R extends AddonGeoArmorItem> GeoModel<R> createGeoModel(AddonGeoArmorItem item) {
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)item);
        return new GeoModel(itemId, item.modelPath, item.texturePath, item.animationsPath);
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        CURRENT_ENTITY = this.currentEntity;
        CURRENT_SLOT = this.currentSlot;
        super.m_7695_(poseStack, buffer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public RenderType getRenderType(T animatable, ResourceLocation texture, @Nullable MultiBufferSource bufferSource, float partialTick) {
        return PalladiumRenderTypes.getArmorTranslucent(texture);
    }

    public void applyBaseTransformations(HumanoidModel<?> baseModel) {
        super.applyBaseTransformations(baseModel);
    }

    public static class GeoModel<T extends AddonGeoArmorItem>
    extends software.bernie.geckolib.model.GeoModel<T> {
        private ResourceLocation modelPath;
        private TextureReference texturePath;
        private ResourceLocation animationsPath;

        public GeoModel(ResourceLocation itemId, ResourceLocation modelPath, TextureReference texturePath, ResourceLocation animationsPath) {
            this.modelPath = modelPath;
            this.texturePath = texturePath;
            this.animationsPath = animationsPath;
            if (this.modelPath == null) {
                this.modelPath = new ResourceLocation(itemId.m_135827_(), "geo/armor/" + itemId.m_135815_() + ".geo.json");
            }
            if (this.texturePath == null) {
                this.texturePath = TextureReference.normal(new ResourceLocation(itemId.m_135827_(), "textures/armor/" + itemId.m_135815_() + ".png"));
            }
            if (this.animationsPath == null) {
                this.animationsPath = new ResourceLocation(itemId.m_135827_(), "animations/armor/" + itemId.m_135815_() + ".animation.json");
            }
        }

        public ResourceLocation getModelResource(AddonGeoArmorItem animatable) {
            return this.modelPath;
        }

        public ResourceLocation getTextureResource(AddonGeoArmorItem animatable) {
            DataContext dataContext;
            Entity entity = CURRENT_ENTITY;
            if (entity instanceof LivingEntity) {
                LivingEntity entity2 = (LivingEntity)entity;
                dataContext = DataContext.forArmorInSlot(entity2, CURRENT_SLOT);
            } else {
                dataContext = DataContext.create();
            }
            return this.texturePath.getTexture(dataContext);
        }

        public ResourceLocation getAnimationResource(AddonGeoArmorItem animatable) {
            return this.animationsPath;
        }

        public RenderType getRenderType(T animatable, ResourceLocation texture) {
            return PalladiumRenderTypes.getArmorTranslucent(texture);
        }
    }
}

