/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.compat.geckolib.renderlayer;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.client.dynamictexture.DynamicTexture;
import net.threetag.palladium.client.dynamictexture.DynamicTextureManager;
import net.threetag.palladium.client.renderer.renderlayer.AbstractPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.IPackRenderLayer;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.client.renderer.renderlayer.RenderLayerStates;
import net.threetag.palladium.client.renderer.renderlayer.RenderTypeFunction;
import net.threetag.palladium.compat.geckolib.playeranimator.ParsedAnimationController;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoLayerState;
import net.threetag.palladium.compat.geckolib.renderlayer.GeckoRenderLayerModel;
import net.threetag.palladium.entity.PalladiumLivingEntityExtension;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.json.GsonUtil;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.object.Color;

public class GeckoRenderLayer
extends AbstractPackRenderLayer {
    private final SkinTypedValue<DynamicTexture> texture;
    private final SkinTypedValue<DynamicTexture> modelLocation;
    public final ResourceLocation animationLocation;
    public final List<ParsedAnimationController<GeckoLayerState>> animationControllers;
    public ResourceLocation cachedTexture;
    public ResourceLocation cachedModel;
    public final RenderTypeFunction renderType;
    private final GeckoRenderLayerModel model;

    public GeckoRenderLayer(SkinTypedValue<DynamicTexture> texture, SkinTypedValue<DynamicTexture> modelLocation, ResourceLocation animationLocation, List<ParsedAnimationController<GeckoLayerState>> animationControllers, RenderTypeFunction renderType) {
        this.texture = texture;
        this.renderType = renderType;
        this.modelLocation = modelLocation;
        this.animationLocation = animationLocation;
        this.animationControllers = animationControllers;
        this.model = new GeckoRenderLayerModel(this);
    }

    public GeckoRenderLayerModel getModel() {
        return this.model;
    }

    @Nullable
    public GeckoLayerState getState(LivingEntity entity) {
        if (entity instanceof PalladiumLivingEntityExtension) {
            GeckoLayerState state;
            PalladiumLivingEntityExtension extension = (PalladiumLivingEntityExtension)entity;
            RenderLayerStates.State state2 = extension.palladium$getRenderLayerStates().getOrCreate(this);
            return state2 instanceof GeckoLayerState ? (state = (GeckoLayerState)state2) : null;
        }
        return null;
    }

    @Override
    public RenderLayerStates.State createState() {
        return new GeckoLayerState(this);
    }

    @Override
    public void render(DataContext context, PoseStack poseStack, MultiBufferSource bufferSource, EntityModel<Entity> parentModel, int packedLight, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        LivingEntity living = context.getLivingEntity();
        if (living != null && IPackRenderLayer.conditionsFulfilled((Entity)living, this.conditions, this.thirdPersonConditions) && parentModel instanceof HumanoidModel) {
            HumanoidModel parentHumanoid = (HumanoidModel)parentModel;
            this.model.setCurrentRenderingFields(this.getState(living), (Entity)living, parentHumanoid);
            this.model.m_8009_(true);
            this.cachedTexture = this.texture.get((Entity)living).getTexture(context);
            this.cachedModel = this.modelLocation.get((Entity)living).getTexture(context);
            this.model.m_7695_(poseStack, this.renderType.createVertexConsumer(bufferSource, this.cachedTexture, false), this.renderType.getPackedLight(packedLight), OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Override
    public void renderArm(DataContext context, HumanoidArm arm, PlayerRenderer playerRenderer, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        LivingEntity living = context.getLivingEntity();
        if (living != null && IPackRenderLayer.conditionsFulfilled((Entity)living, this.conditions, this.firstPersonConditions)) {
            GeoBone bone;
            GeckoLayerState state = this.getState(living);
            this.model.setCurrentRenderingFields(state, (Entity)living, (HumanoidModel)playerRenderer.m_7200_());
            this.cachedTexture = this.texture.get((Entity)living).getTexture(context);
            this.cachedModel = this.modelLocation.get((Entity)living).getTexture(context);
            this.model.grabRelevantBones(this.model.getGeoModel().getBakedModel(this.model.getGeoModel().getModelResource((GeoAnimatable)this.model.currentState)));
            GeoBone geoBone = bone = arm == HumanoidArm.RIGHT ? this.model.getRightArmBone() : this.model.getLeftArmBone();
            if (state != null && bone != null) {
                ((PlayerModel)playerRenderer.m_7200_()).m_102872_((HumanoidModel)this.model);
                this.model.applyBaseTransformations((HumanoidModel)playerRenderer.m_7200_());
                float partialTick = Minecraft.m_91087_().m_91296_();
                VertexConsumer buffer = state.layer.renderType.createVertexConsumer(bufferSource, this.model.getTextureLocation(state), false);
                poseStack.m_85836_();
                poseStack.m_252880_(0.0f, 1.5f, 0.0f);
                poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
                Color renderColor = this.model.getRenderColor(state, partialTick, this.renderType.getPackedLight(packedLight));
                float red = renderColor.getRedFloat();
                float green = renderColor.getGreenFloat();
                float blue = renderColor.getBlueFloat();
                float alpha = renderColor.getAlphaFloat();
                int packedOverlay = this.model.getPackedOverlay(state, 0.0f, partialTick);
                AnimationState animationState = new AnimationState((GeoAnimatable)state, 0.0f, 0.0f, partialTick, false);
                long instanceId = this.model.getInstanceId(state);
                animationState.setData(DataTickets.TICK, (Object)state.getTick(living));
                animationState.setData(DataTickets.ENTITY, (Object)living);
                animationState.setData(DataTickets.EQUIPMENT_SLOT, (Object)EquipmentSlot.CHEST);
                this.model.getGeoModel().addAdditionalStateData((GeoAnimatable)state, instanceId, (arg_0, arg_1) -> ((AnimationState)animationState).setData(arg_0, arg_1));
                this.model.getGeoModel().handleAnimations((GeoAnimatable)state, instanceId, animationState);
                this.model.renderRecursively(poseStack, state, bone, null, bufferSource, buffer, false, partialTick, this.renderType.getPackedLight(packedLight), packedOverlay, red, green, blue, alpha);
                poseStack.m_85849_();
            }
        }
    }

    public static GeckoRenderLayer parse(JsonObject json) {
        SkinTypedValue<DynamicTexture> modelLocation = SkinTypedValue.fromJSON(json.get("model"), DynamicTextureManager::fromJson);
        SkinTypedValue<DynamicTexture> texture = SkinTypedValue.fromJSON(json.get("texture"), DynamicTextureManager::fromJson);
        RenderTypeFunction renderType = PackRenderLayerManager.getRenderType(new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"render_type", (String)"solid")));
        if (renderType == null) {
            throw new JsonParseException("Unknown render type '" + String.valueOf(new ResourceLocation(GsonHelper.m_13851_((JsonObject)json, (String)"render_type", (String)"solid"))) + "'");
        }
        GeckoRenderLayer layer = new GeckoRenderLayer(texture, modelLocation, GsonUtil.getAsResourceLocation(json, "animation_file", null), GsonUtil.fromListOrPrimitive(json.get("animation_controller"), el -> ParsedAnimationController.controllerFromJson(el.getAsJsonObject()), Collections.emptyList()), renderType);
        JsonObject bonesJson = GsonHelper.m_13841_((JsonObject)json, (String)"bones", (JsonObject)new JsonObject());
        layer.model.headBone = GsonHelper.m_13851_((JsonObject)bonesJson, (String)"head", (String)layer.model.headBone);
        layer.model.bodyBone = GsonHelper.m_13851_((JsonObject)bonesJson, (String)"body", (String)layer.model.bodyBone);
        layer.model.rightArmBone = GsonHelper.m_13851_((JsonObject)bonesJson, (String)"right_arm", (String)layer.model.rightArmBone);
        layer.model.leftArmBone = GsonHelper.m_13851_((JsonObject)bonesJson, (String)"left_arm", (String)layer.model.leftArmBone);
        layer.model.rightLegBone = GsonHelper.m_13851_((JsonObject)bonesJson, (String)"right_leg", (String)layer.model.rightLegBone);
        layer.model.leftLegBone = GsonHelper.m_13851_((JsonObject)bonesJson, (String)"left_leg", (String)layer.model.leftLegBone);
        return IPackRenderLayer.parseConditions(layer, json);
    }
}

