/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.ComponentProperty;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.IconProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class PropertyBuyableCondition
extends BuyableCondition {
    private final String propertyKey;
    private final int amount;
    private final IIcon icon;
    private final Component description;

    public PropertyBuyableCondition(String propertyKey, int amount, IIcon icon, Component description) {
        this.propertyKey = propertyKey;
        this.amount = amount;
        this.icon = icon;
        this.description = description;
    }

    @Override
    public AbilityConfiguration.UnlockData createData() {
        return new AbilityConfiguration.UnlockData(this.icon, this.amount, this.description);
    }

    @Override
    public boolean isAvailable(LivingEntity entity) {
        AtomicBoolean result = new AtomicBoolean(false);
        EntityPropertyHandler.getHandler((Entity)entity).ifPresent(handler -> {
            PalladiumProperty<?> property = handler.getPropertyByName(this.propertyKey);
            if (property instanceof IntegerProperty) {
                IntegerProperty integerProperty = (IntegerProperty)property;
                int value = handler.get(integerProperty);
                result.set(value >= this.amount);
            }
        });
        return result.get();
    }

    @Override
    public boolean takeFromEntity(LivingEntity entity) {
        AtomicBoolean result = new AtomicBoolean(false);
        EntityPropertyHandler.getHandler((Entity)entity).ifPresent(handler -> {
            IntegerProperty integerProperty;
            int value;
            PalladiumProperty<?> property = handler.getPropertyByName(this.propertyKey);
            if (property instanceof IntegerProperty && (value = handler.get(integerProperty = (IntegerProperty)property).intValue()) >= this.amount) {
                handler.set(integerProperty, value - this.amount);
                result.set(true);
            }
        });
        return result.get();
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.PROPERTY_BUYABLE.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<String> PROPERTY = new StringProperty("property").configurable("Name of the (integer) palladium property");
        public static final PalladiumProperty<Integer> SCORE = new IntegerProperty("score").configurable("Required value of the property");
        public static final PalladiumProperty<IIcon> ICON = new IconProperty("icon").configurable("Icon that will be displayed during buying");
        public static final PalladiumProperty<Component> DESCRIPTION = new ComponentProperty("description").configurable("Name of the property that will be displayed during buying");

        public Serializer() {
            this.withProperty(PROPERTY, "property_name");
            this.withProperty(SCORE, 3);
            this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42116_));
            this.withProperty(DESCRIPTION, Component.m_237113_((String)"Property"));
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.DATA;
        }

        @Override
        public Condition make(JsonObject json) {
            return new PropertyBuyableCondition(this.getProperty(json, PROPERTY), this.getProperty(json, SCORE), this.getProperty(json, ICON), this.getProperty(json, DESCRIPTION));
        }

        @Override
        public String getDocumentationDescription() {
            return "A buyable condition that requires a certain value in an integer palladium property.";
        }
    }
}

