/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.condition;

import com.google.gson.JsonObject;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Score;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.condition.Condition;
import net.threetag.palladium.condition.ConditionEnvironment;
import net.threetag.palladium.condition.ConditionSerializer;
import net.threetag.palladium.condition.ConditionSerializers;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.util.icon.IIcon;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.ComponentProperty;
import net.threetag.palladium.util.property.IconProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class ScoreboardScoreBuyableCondition
extends BuyableCondition {
    private final String objective;
    private final int amount;
    private final IIcon icon;
    private final Component description;

    public ScoreboardScoreBuyableCondition(String objective, int amount, IIcon icon, Component description) {
        this.objective = objective;
        this.amount = amount;
        this.icon = icon;
        this.description = description;
    }

    @Override
    public AbilityConfiguration.UnlockData createData() {
        return new AbilityConfiguration.UnlockData(this.icon, this.amount, this.description);
    }

    @Override
    public boolean isAvailable(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            Objective objective = player.m_36329_().m_83477_(this.objective);
            return objective != null && player.m_36329_().m_83471_(player.m_6302_(), objective).m_83400_() >= this.amount;
        }
        return false;
    }

    @Override
    public boolean takeFromEntity(LivingEntity entity) {
        Score score;
        Player player;
        Objective objective;
        if (entity instanceof Player && (objective = (player = (Player)entity).m_36329_().m_83477_(this.objective)) != null && (score = player.m_36329_().m_83471_(player.m_6302_(), objective)).m_83400_() >= this.amount) {
            score.m_83402_(score.m_83400_() - this.amount);
            return true;
        }
        return false;
    }

    @Override
    public ConditionSerializer getSerializer() {
        return (ConditionSerializer)ConditionSerializers.SCOREBOARD_SCORE_BUYABLE.get();
    }

    public static class Serializer
    extends ConditionSerializer {
        public static final PalladiumProperty<String> OBJECTIVE = new StringProperty("objective").configurable("Name of the scoreboard objective");
        public static final PalladiumProperty<Integer> SCORE = new IntegerProperty("score").configurable("Required player score for the scoreboard objective");
        public static final PalladiumProperty<IIcon> ICON = new IconProperty("icon").configurable("Icon that will be displayed during buying");
        public static final PalladiumProperty<Component> DESCRIPTION = new ComponentProperty("description").configurable("Name of the score that will be displayed during buying");

        public Serializer() {
            this.withProperty(OBJECTIVE, "objective_name");
            this.withProperty(SCORE, 3);
            this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42116_));
            this.withProperty(DESCRIPTION, Component.m_237113_((String)"Scoreboard Score"));
        }

        @Override
        public ConditionEnvironment getContextEnvironment() {
            return ConditionEnvironment.DATA;
        }

        @Override
        public Condition make(JsonObject json) {
            return new ScoreboardScoreBuyableCondition(this.getProperty(json, OBJECTIVE), this.getProperty(json, SCORE), this.getProperty(json, ICON), this.getProperty(json, DESCRIPTION));
        }

        @Override
        public String getDocumentationDescription() {
            return "A buyable condition that requires a certain score for a scoreboard objective.";
        }
    }
}

