/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.entity;

import com.google.gson.JsonParseException;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.accessory.Accessory;
import net.threetag.palladium.client.model.animation.PalladiumAnimationRegistry;
import net.threetag.palladium.client.renderer.item.armor.ArmorRendererData;
import net.threetag.palladium.client.renderer.renderlayer.PackRenderLayerManager;
import net.threetag.palladium.compat.mermod.MermodClientCompat;
import net.threetag.palladium.entity.PlayerModelCacheExtension;
import net.threetag.palladium.item.ArmorWithRenderer;
import net.threetag.palladium.mixin.client.PlayerRendererInvoker;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.power.ability.HideBodyPartAbility;
import net.threetag.palladium.power.ability.RemoveBodyPartAbility;
import net.threetag.palladium.util.SizeUtil;
import net.threetag.palladium.util.context.DataContext;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public enum BodyPart {
    HEAD("head", false),
    HEAD_OVERLAY("head_overlay", true),
    CHEST("chest", false),
    CHEST_OVERLAY("chest_overlay", true),
    RIGHT_ARM("right_arm", false),
    RIGHT_ARM_OVERLAY("right_arm_overlay", true),
    LEFT_ARM("left_arm", false),
    LEFT_ARM_OVERLAY("left_arm_overlay", true),
    RIGHT_LEG("right_leg", false),
    RIGHT_LEG_OVERLAY("right_leg_overlay", true),
    LEFT_LEG("left_leg", false),
    LEFT_LEG_OVERLAY("left_leg_overlay", true),
    CAPE("cape", false);

    private final String name;
    private final boolean overlay;
    public static final List<Item> HIDES_LAYER;

    private BodyPart(String name, boolean overlay) {
        this.name = name;
        this.overlay = overlay;
    }

    public String getName() {
        return this.name;
    }

    public boolean isOverlay() {
        return this.overlay;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public ModelPart getModelPart(HumanoidModel<?> model) {
        PlayerModel pl;
        PlayerModel playerModel = model instanceof PlayerModel ? (pl = (PlayerModel)model) : null;
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case HEAD -> model.f_102808_;
            case HEAD_OVERLAY -> model.f_102809_;
            case CHEST -> model.f_102810_;
            case CHEST_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.f_103378_;
                }
                yield null;
            }
            case RIGHT_ARM -> model.f_102811_;
            case RIGHT_ARM_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.f_103375_;
                }
                yield null;
            }
            case LEFT_ARM -> model.f_102812_;
            case LEFT_ARM_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.f_103374_;
                }
                yield null;
            }
            case RIGHT_LEG -> model.f_102813_;
            case RIGHT_LEG_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.f_103377_;
                }
                yield null;
            }
            case LEFT_LEG -> model.f_102814_;
            case LEFT_LEG_OVERLAY -> {
                if (playerModel != null) {
                    yield playerModel.f_103376_;
                }
                yield null;
            }
            case CAPE -> playerModel != null ? playerModel.f_103373_ : null;
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void setVisibility(HumanoidModel<?> model, boolean visible) {
        ModelPart part = this.getModelPart(model);
        if (part != null) {
            part.f_104207_ = visible;
        }
    }

    public static BodyPart fromJson(String name) {
        BodyPart part = BodyPart.byName(name);
        if (part != null) {
            return part;
        }
        throw new JsonParseException("Unknown body part '" + name + "'");
    }

    public static BodyPart byName(String name) {
        for (BodyPart bodyPart : BodyPart.values()) {
            if (!name.equalsIgnoreCase(bodyPart.name)) continue;
            return bodyPart;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void hideHiddenOrRemovedParts(HumanoidModel<?> model, LivingEntity entity, ModifiedBodyPartResult result) {
        for (BodyPart part : BodyPart.values()) {
            if (!result.isHiddenOrRemoved(part)) continue;
            part.setVisibility(model, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void hideRemovedParts(HumanoidModel<?> model, LivingEntity entity, ModifiedBodyPartResult result) {
        for (BodyPart part : BodyPart.values()) {
            if (!result.isRemoved(part)) continue;
            part.setVisibility(model, false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void resetBodyParts(LivingEntity entity, HumanoidModel<?> model) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_5833_()) {
                model.m_8009_(false);
                model.f_102808_.f_104207_ = true;
                model.f_102809_.f_104207_ = true;
            } else {
                model.m_8009_(true);
                model.f_102809_.f_104207_ = player.m_36170_(PlayerModelPart.HAT);
                if (model instanceof PlayerModel) {
                    PlayerModel playerModel = (PlayerModel)model;
                    playerModel.f_103378_.f_104207_ = player.m_36170_(PlayerModelPart.JACKET);
                    playerModel.f_103376_.f_104207_ = player.m_36170_(PlayerModelPart.LEFT_PANTS_LEG);
                    playerModel.f_103377_.f_104207_ = player.m_36170_(PlayerModelPart.RIGHT_PANTS_LEG);
                    playerModel.f_103374_.f_104207_ = player.m_36170_(PlayerModelPart.LEFT_SLEEVE);
                    playerModel.f_103375_.f_104207_ = player.m_36170_(PlayerModelPart.RIGHT_SLEEVE);
                    playerModel.f_103373_.f_104207_ = player.m_36170_(PlayerModelPart.CAPE);
                    if (MermodClientCompat.INSTANCE.shouldRenderTail(player)) {
                        playerModel.f_102813_.f_104207_ = false;
                        playerModel.f_103377_.f_104207_ = false;
                        playerModel.f_102814_.f_104207_ = false;
                        playerModel.f_103376_.f_104207_ = false;
                    }
                }
            }
        } else {
            model.m_8009_(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ModifiedBodyPartResult getModifiedBodyParts(LivingEntity entity, boolean isFirstPerson) {
        return BodyPart.getModifiedBodyParts(entity, isFirstPerson, true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ModifiedBodyPartResult getModifiedBodyParts(LivingEntity entity, boolean isFirstPerson, boolean includeAccessories) {
        ModifiedBodyPartResult result = new ModifiedBodyPartResult();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                ArmorRendererData renderer;
                ArmorWithRenderer armorWithRenderer;
                Object object;
                ItemStack stack;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !HIDES_LAYER.contains((stack = player.m_6844_(slot)).m_41720_()) && (!((object = stack.m_41720_()) instanceof ArmorWithRenderer) || !((object = (armorWithRenderer = (ArmorWithRenderer)object).getCachedArmorRenderer()) instanceof ArmorRendererData) || !(renderer = (ArmorRendererData)object).hidesSecondPlayerLayer(DataContext.forArmorInSlot((LivingEntity)player, slot)))) continue;
                if (slot == EquipmentSlot.HEAD) {
                    result.remove(HEAD_OVERLAY);
                    continue;
                }
                if (slot == EquipmentSlot.CHEST) {
                    result.remove(CHEST_OVERLAY);
                    result.remove(RIGHT_ARM_OVERLAY);
                    result.remove(LEFT_ARM_OVERLAY);
                    continue;
                }
                result.remove(RIGHT_LEG_OVERLAY);
                result.remove(LEFT_LEG_OVERLAY);
            }
            if (includeAccessories) {
                Accessory.getPlayerData(player).ifPresent(data -> data.getSlots().forEach((slot, accessories) -> {
                    if (!accessories.isEmpty()) {
                        for (BodyPart part : slot.getHiddenBodyParts(player)) {
                            result.hide(part);
                        }
                    }
                }));
            }
        }
        for (AbilityInstance bodyPartHide : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.HIDE_BODY_PART.get())) {
            if (isFirstPerson && !bodyPartHide.getProperty(HideBodyPartAbility.AFFECTS_FIRST_PERSON).booleanValue()) continue;
            for (BodyPart part : bodyPartHide.getProperty(HideBodyPartAbility.BODY_PARTS)) {
                result.hide(part);
            }
        }
        for (AbilityInstance bodyPartHide : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.REMOVE_BODY_PART.get())) {
            if (isFirstPerson && !bodyPartHide.getProperty(RemoveBodyPartAbility.AFFECTS_FIRST_PERSON).booleanValue()) continue;
            for (BodyPart part : bodyPartHide.getProperty(RemoveBodyPartAbility.BODY_PARTS)) {
                result.remove(part);
            }
        }
        PackRenderLayerManager.forEachLayer((Entity)entity, (context, layer) -> {
            for (BodyPart part : layer.getHiddenBodyParts(entity)) {
                result.hide(part);
            }
        });
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Matrix4f getTransformationMatrix(BodyPart part, Vector3f offset, HumanoidModel<?> model, AbstractClientPlayer player, float partialTicks) {
        PoseStack poseStack = new PoseStack();
        ModelPart modelPart = part.getModelPart(model);
        if (modelPart == null) {
            return poseStack.m_85850_().m_252922_();
        }
        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_((Entity)player);
        if (renderer instanceof PlayerRendererInvoker) {
            Entity entity;
            PlayerRendererInvoker invoker = (PlayerRendererInvoker)renderer;
            float width = SizeUtil.getInstance().getModelWidthScale((Entity)player, partialTicks);
            float height = SizeUtil.getInstance().getModelHeightScale((Entity)player, partialTicks);
            poseStack.m_85841_(width, height, width);
            float f = Mth.m_14189_((float)partialTicks, (float)player.f_20884_, (float)player.f_20883_);
            float g = Mth.m_14189_((float)partialTicks, (float)player.f_20886_, (float)player.f_20885_);
            if (player.m_20159_() && (entity = player.m_20202_()) instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                f = Mth.m_14189_((float)partialTicks, (float)livingEntity.f_20884_, (float)livingEntity.f_20883_);
                float h = g - f;
                float i = Mth.m_14177_((float)h);
                if (i < -85.0f) {
                    i = -85.0f;
                }
                if (i >= 85.0f) {
                    i = 85.0f;
                }
                f = g - i;
                if (i * i > 2500.0f) {
                    f += i * 0.2f;
                }
            }
            invoker.invokeSetupRotations(player, poseStack, (float)player.f_19797_ + partialTicks, f, partialTicks);
            PalladiumAnimationRegistry.setupRotations((PlayerRenderer)renderer, player, poseStack, partialTicks);
            poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
            invoker.invokeScale(player, poseStack, partialTicks);
            poseStack.m_252880_(0.0f, -1.501f, 0.0f);
            modelPart.m_104299_(poseStack);
            poseStack.m_252880_(offset.x, offset.y, offset.z);
        }
        return poseStack.m_85850_().m_252922_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Matrix4f getTransformationMatrix(BodyPart part, Vector3f offset, AbstractClientPlayer player, float partialTicks) {
        if (player instanceof PlayerModelCacheExtension) {
            PlayerModelCacheExtension ext = (PlayerModelCacheExtension)player;
            return BodyPart.getTransformationMatrix(part, offset, ext.palladium$getCachedModel(), player, partialTicks);
        }
        return new Matrix4f();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Vec3 getInWorldPosition(BodyPart part, Vector3f offset, HumanoidModel<?> model, AbstractClientPlayer player, float partialTicks) {
        Vector3f vec = new Vector3f(0.0f, 0.0f, 0.0f);
        vec = BodyPart.getTransformationMatrix(part, offset, model, player, partialTicks).transformPosition(vec);
        return player.m_20318_(partialTicks).m_82520_((double)vec.x, (double)vec.y, (double)vec.z);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Vec3 getInWorldPosition(BodyPart part, Vector3f offset, AbstractClientPlayer player, float partialTicks) {
        if (player instanceof PlayerModelCacheExtension) {
            PlayerModelCacheExtension ext = (PlayerModelCacheExtension)player;
            return BodyPart.getInWorldPosition(part, offset, ext.palladium$getCachedModel(), player, partialTicks);
        }
        return player.m_20318_(partialTicks);
    }

    static {
        HIDES_LAYER = new ArrayList<Item>();
    }

    public static class ModifiedBodyPartResult {
        private final Map<BodyPart, Integer> states = new HashMap<BodyPart, Integer>();

        public ModifiedBodyPartResult hide(BodyPart part) {
            return this.set(part, false);
        }

        public ModifiedBodyPartResult remove(BodyPart part) {
            return this.set(part, true);
        }

        public ModifiedBodyPartResult set(BodyPart part, boolean remove) {
            int mod;
            int n = mod = remove ? 2 : 1;
            if (!this.states.containsKey((Object)part)) {
                this.states.put(part, mod);
            } else {
                this.states.put(part, Math.max(this.states.get((Object)part), mod));
            }
            return this;
        }

        public boolean isHiddenOrRemoved(BodyPart bodyPart) {
            return this.states.containsKey((Object)bodyPart);
        }

        public boolean isHidden(BodyPart bodyPart) {
            return this.states.containsKey((Object)bodyPart) && this.states.get((Object)bodyPart) == 1;
        }

        public boolean isRemoved(BodyPart bodyPart) {
            return this.states.containsKey((Object)bodyPart) && this.states.get((Object)bodyPart) == 2;
        }
    }
}

