/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetDisplayObjectivePacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;
import net.threetag.palladium.world.TrackedScoresManager;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ServerScoreboard.class})
public abstract class ServerScoreboardMixin {
    @Shadow
    @Final
    private MinecraftServer f_136193_;

    @Shadow
    public abstract List<Packet<?>> m_136233_(Objective var1);

    @Shadow
    public abstract void m_136231_(Objective var1);

    @Inject(method={"setDisplayObjective"}, at={@At(value="HEAD")})
    public void setDisplayObjective(int objectiveSlot, @Nullable Objective objective, CallbackInfo ci) {
        Scoreboard scoreboard = (Scoreboard)this;
        Objective previousObj = scoreboard.m_83416_(objectiveSlot);
        if (previousObj != null && previousObj != objective && TrackedScoresManager.INSTANCE.isTracked(previousObj.m_83320_())) {
            this.f_136193_.m_6846_().m_11268_((Packet)new ClientboundSetDisplayObjectivePacket(objectiveSlot, null));
        }
    }

    @Inject(method={"stopTrackingObjective"}, at={@At(value="HEAD")}, cancellable=true)
    public void stopTrackingObjective(Objective objective, CallbackInfo ci) {
        if (TrackedScoresManager.INSTANCE.isTracked(objective.m_83320_())) {
            ci.cancel();
            for (Packet<?> packet : this.m_136233_(objective)) {
                this.f_136193_.m_6846_().m_11268_(packet);
            }
        }
    }

    @Inject(method={"getStopTrackingPackets"}, at={@At(value="RETURN")}, cancellable=true)
    public void getStopTrackingPackets(Objective objective, CallbackInfoReturnable<List<Packet<?>>> cir) {
        if (TrackedScoresManager.INSTANCE.isTracked(objective.m_83320_())) {
            ArrayList<ClientboundSetDisplayObjectivePacket> packets = new ArrayList<ClientboundSetDisplayObjectivePacket>();
            Scoreboard scoreboard = (Scoreboard)this;
            for (int i = 0; i < 19; ++i) {
                if (scoreboard.m_83416_(i) != objective) continue;
                packets.add(new ClientboundSetDisplayObjectivePacket(i, null));
            }
            cir.setReturnValue(packets);
        }
    }

    @Inject(method={"onObjectiveAdded"}, at={@At(value="RETURN")})
    public void onObjectiveAdded(Objective objective, CallbackInfo ci) {
        if (TrackedScoresManager.INSTANCE.isTracked(objective.m_83320_())) {
            this.m_136231_(objective);
        }
    }
}

