/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.threetag.palladium.client.PalladiumKeyMappings;
import net.threetag.palladium.client.screen.AbilityWheelRenderer;
import net.threetag.palladium.network.AbilityKeyPressedMessage;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.EntityGlowAbility;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Minecraft.class})
public class MinecraftMixin {
    @Shadow
    public LocalPlayer f_91074_;
    @Shadow
    public Entity f_91075_;
    @Shadow
    @Final
    public Options f_91066_;
    @Shadow
    public MultiPlayerGameMode f_91072_;

    @Inject(method={"startAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void startAttackAbilityWheel(CallbackInfoReturnable<Boolean> cir) {
        if (AbilityWheelRenderer.CURRENT_WHEEL != null) {
            AbilityInstance ability = AbilityWheelRenderer.CURRENT_WHEEL.getSelectedAbility();
            if (ability != null && !ability.isOnCooldown()) {
                new AbilityKeyPressedMessage(ability.getReference(), true).send();
                PalladiumKeyMappings.LEFT_CLICKED_ABILITY = ability;
                AbilityWheelRenderer.setWheel(null);
            }
            cir.setReturnValue((Object)false);
            this.f_91066_.f_92096_.m_90859_();
            this.f_91066_.f_92096_.m_7249_(false);
        }
    }

    @Inject(method={"startAttack"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;hasMissTime()Z")}, cancellable=true)
    private void startAttackStartAbility(CallbackInfoReturnable<Boolean> cir) {
        if (PalladiumKeyMappings.LEFT_CLICKED_ABILITY == null && AbilityWheelRenderer.CURRENT_WHEEL == null) {
            AbilityInstance entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.LEFT_CLICK);
            if (entry != null && entry.isUnlocked() && (!entry.getConfiguration().needsEmptyHand() || this.f_91074_.m_21205_().m_41619_())) {
                AbilityConfiguration.KeyPressType pressType = entry.getConfiguration().getKeyPressType();
                if (pressType == AbilityConfiguration.KeyPressType.ACTION) {
                    if (!entry.isOnCooldown()) {
                        new AbilityKeyPressedMessage(entry.getReference(), true).send();
                        PalladiumKeyMappings.LEFT_CLICKED_ABILITY = entry;
                        cir.setReturnValue((Object)false);
                    }
                } else if (pressType == AbilityConfiguration.KeyPressType.ACTIVATION) {
                    if (!entry.isOnCooldown() && !entry.isEnabled()) {
                        new AbilityKeyPressedMessage(entry.getReference(), true).send();
                        PalladiumKeyMappings.LEFT_CLICKED_ABILITY = entry;
                        cir.setReturnValue((Object)false);
                    }
                } else {
                    new AbilityKeyPressedMessage(entry.getReference(), true).send();
                    PalladiumKeyMappings.LEFT_CLICKED_ABILITY = entry;
                    cir.setReturnValue((Object)false);
                }
            }
        } else {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"startAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void startAttackStopAbility(CallbackInfoReturnable<Boolean> cir) {
        if (PalladiumKeyMappings.LEFT_CLICKED_ABILITY != null) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"startUseItem"}, at={@At(value="TAIL")}, cancellable=true)
    private void startUseItemStartAbility(CallbackInfo ci) {
        if (PalladiumKeyMappings.RIGHT_CLICKED_ABILITY == null) {
            AbilityInstance entry = PalladiumKeyMappings.getPrioritisedKeyedAbility(AbilityConfiguration.KeyType.RIGHT_CLICK);
            if (entry != null && entry.isUnlocked() && (!entry.getConfiguration().needsEmptyHand() || this.f_91074_.m_21205_().m_41619_())) {
                AbilityConfiguration.KeyPressType pressType = entry.getConfiguration().getKeyPressType();
                if (pressType == AbilityConfiguration.KeyPressType.ACTION) {
                    if (!entry.isOnCooldown()) {
                        new AbilityKeyPressedMessage(entry.getReference(), true).send();
                        PalladiumKeyMappings.RIGHT_CLICKED_ABILITY = entry;
                        ci.cancel();
                    }
                } else if (pressType == AbilityConfiguration.KeyPressType.ACTIVATION) {
                    if (!entry.isOnCooldown() && !entry.isEnabled()) {
                        new AbilityKeyPressedMessage(entry.getReference(), true).send();
                        PalladiumKeyMappings.RIGHT_CLICKED_ABILITY = entry;
                        ci.cancel();
                    }
                } else {
                    new AbilityKeyPressedMessage(entry.getReference(), true).send();
                    PalladiumKeyMappings.RIGHT_CLICKED_ABILITY = entry;
                    ci.cancel();
                }
            }
        } else {
            ci.cancel();
        }
    }

    @Inject(method={"startUseItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void startUseItemStopAbility(CallbackInfo ci) {
        if (PalladiumKeyMappings.RIGHT_CLICKED_ABILITY != null) {
            ci.cancel();
        }
    }

    @Inject(method={"shouldEntityAppearGlowing"}, at={@At(value="RETURN")}, cancellable=true)
    private void showGlow(Entity entity, CallbackInfoReturnable<Boolean> cir) {
        if (EntityGlowAbility.shouldGlow(entity, this.f_91075_)) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"continueAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void continueAttack(boolean leftClick, CallbackInfo ci) {
        if (leftClick && AbilityWheelRenderer.CURRENT_WHEEL != null) {
            AbilityInstance ability = AbilityWheelRenderer.CURRENT_WHEEL.getSelectedAbility();
            if (ability != null && !ability.isOnCooldown()) {
                new AbilityKeyPressedMessage(ability.getReference(), true).send();
                PalladiumKeyMappings.LEFT_CLICKED_ABILITY = ability;
                AbilityWheelRenderer.setWheel(null);
            }
            ci.cancel();
            this.f_91066_.f_92096_.m_90859_();
            this.f_91066_.f_92096_.m_7249_(false);
            this.f_91072_.m_105276_();
        }
    }
}

