/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.condition.BuyableCondition;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladiumcore.network.MessageC2S;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageType;

public class BuyAbilityUnlockMessage
extends MessageC2S {
    private final AbilityReference reference;

    public BuyAbilityUnlockMessage(AbilityReference reference) {
        this.reference = reference;
    }

    public BuyAbilityUnlockMessage(FriendlyByteBuf buf) {
        this.reference = AbilityReference.fromBuffer(buf);
    }

    public MessageType getType() {
        return PalladiumNetwork.BUY_ABILITY_UNLOCK;
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.reference.toBuffer(buf);
    }

    public void handle(MessageContext context) {
        BuyableCondition buyableCondition;
        AbilityInstance entry = this.reference.getEntry((LivingEntity)context.getPlayer());
        if (entry != null && (buyableCondition = entry.getConfiguration().findBuyCondition()) != null && !entry.getProperty(BuyableCondition.BOUGHT).booleanValue() && buyableCondition.isAvailable((LivingEntity)context.getPlayer())) {
            buyableCondition.buy((LivingEntity)context.getPlayer(), entry);
        }
    }
}

