/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.screen.power.BuyAbilityScreen;
import net.threetag.palladium.client.screen.power.PowersScreen;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.ability.AbilityConfiguration;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;
import org.jetbrains.annotations.NotNull;

public class OpenAbilityBuyScreenMessage
extends MessageS2C {
    private final AbilityReference reference;
    private final AbilityConfiguration.UnlockData unlockData;
    private final boolean available;

    public OpenAbilityBuyScreenMessage(AbilityReference reference, AbilityConfiguration.UnlockData unlockData, boolean available) {
        this.reference = reference;
        this.unlockData = unlockData;
        this.available = available;
    }

    public OpenAbilityBuyScreenMessage(FriendlyByteBuf buf) {
        this.reference = AbilityReference.fromBuffer(buf);
        this.unlockData = new AbilityConfiguration.UnlockData(buf);
        this.available = buf.readBoolean();
    }

    @NotNull
    public MessageType getType() {
        return PalladiumNetwork.OPEN_ABILITY_BUY_SCREEN;
    }

    public void toBytes(FriendlyByteBuf buf) {
        this.reference.toBuffer(buf);
        this.unlockData.toBuffer(buf);
        buf.writeBoolean(this.available);
    }

    public void handle(MessageContext context) {
        this.handleClient(context);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient(MessageContext context) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof PowersScreen) {
            PowersScreen powersScreen = (PowersScreen)screen;
            AbilityInstance entry = this.reference.getEntry((LivingEntity)Minecraft.m_91087_().f_91074_);
            if (entry != null) {
                powersScreen.openOverlayScreen(new BuyAbilityScreen(this.reference, this.unlockData, this.available, powersScreen));
            }
        }
    }
}

