/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.network;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.network.PalladiumNetwork;
import net.threetag.palladium.power.ClientPowerManager;
import net.threetag.palladium.power.Power;
import net.threetag.palladiumcore.network.MessageContext;
import net.threetag.palladiumcore.network.MessageS2C;
import net.threetag.palladiumcore.network.MessageType;

public class SyncPowersMessage
extends MessageS2C {
    private final Map<ResourceLocation, Power> powers;

    public SyncPowersMessage(Map<ResourceLocation, Power> powers) {
        this.powers = powers;
    }

    public SyncPowersMessage(FriendlyByteBuf buf) {
        this.powers = new HashMap<ResourceLocation, Power>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            ResourceLocation id = buf.m_130281_();
            this.powers.put(id, Power.fromBuffer(id, buf));
        }
    }

    public MessageType getType() {
        return PalladiumNetwork.SYNC_POWERS;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.powers.size());
        this.powers.forEach((id, power) -> {
            buf.m_130085_(id);
            power.toBuffer(buf);
        });
    }

    public void handle(MessageContext context) {
        this.handleClient();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleClient() {
        ClientPowerManager.updatePowers(this.powers);
    }
}

