/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.DefaultPowerHolder;
import net.threetag.palladium.power.IPowerHandler;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.IPowerValidator;
import net.threetag.palladium.power.Power;

public class PowerCollector {
    private final LivingEntity entity;
    private final IPowerHandler handler;
    private final List<IPowerHolder> toRemove;
    private final List<DefaultPowerHolder> powerHolders = new ArrayList<DefaultPowerHolder>();

    public PowerCollector(LivingEntity entity, IPowerHandler handler, List<IPowerHolder> toRemove) {
        this.entity = entity;
        this.handler = handler;
        this.toRemove = toRemove;
    }

    public void addPower(Power power, Supplier<IPowerValidator> validatorSupplier) {
        if (power == null) {
            return;
        }
        IPowerHolder found = null;
        for (IPowerHolder holder : this.toRemove) {
            if (holder.getPower() != power) continue;
            found = holder;
            break;
        }
        if (found != null) {
            found.switchValidator(validatorSupplier.get());
            this.toRemove.remove(found);
            return;
        }
        if (!this.handler.hasPower(power)) {
            this.powerHolders.add(new DefaultPowerHolder(this.entity, power, validatorSupplier.get()));
        }
    }

    public List<DefaultPowerHolder> getAdded() {
        return this.powerHolders;
    }
}

