/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.threetag.palladium.power.Power;
import net.threetag.palladium.power.PowerManager;
import net.threetag.palladium.util.property.PalladiumProperties;

public class SuperpowerUtil {
    public static Collection<Power> getSuperpowers(LivingEntity entity) {
        ArrayList<Power> powers = new ArrayList<Power>();
        for (ResourceLocation id : PalladiumProperties.SUPERPOWER_IDS.get((Entity)entity)) {
            Power power = PowerManager.getInstance(entity.m_9236_()).getPower(id);
            if (power == null) continue;
            powers.add(power);
        }
        return powers;
    }

    public static Collection<ResourceLocation> getSuperpowerIds(LivingEntity entity) {
        return PalladiumProperties.SUPERPOWER_IDS.get((Entity)entity);
    }

    public static void setSuperpower(LivingEntity entity, ResourceLocation powerId) {
        PalladiumProperties.SUPERPOWER_IDS.set((Entity)entity, Collections.singletonList(powerId));
    }

    public static void setSuperpower(LivingEntity entity, Power power) {
        SuperpowerUtil.setSuperpower(entity, power.getId());
    }

    public static void setSuperpowerIds(LivingEntity entity, List<ResourceLocation> powerIds) {
        PalladiumProperties.SUPERPOWER_IDS.set((Entity)entity, powerIds);
    }

    public static void setSuperpowers(LivingEntity entity, List<Power> powers) {
        SuperpowerUtil.setSuperpowerIds(entity, powers.stream().map(Power::getId).collect(Collectors.toList()));
    }

    public static void setSuperpowerIds(LivingEntity entity, ResourceLocation ... powerIds) {
        PalladiumProperties.SUPERPOWER_IDS.set((Entity)entity, Arrays.asList(powerIds));
    }

    public static void setSuperpower(LivingEntity entity, Power ... powers) {
        SuperpowerUtil.setSuperpowerIds(entity, Arrays.stream(powers).map(Power::getId).collect(Collectors.toList()));
    }

    public static boolean hasSuperpower(LivingEntity entity, ResourceLocation powerId) {
        return PalladiumProperties.SUPERPOWER_IDS.get((Entity)entity).contains(powerId);
    }

    public static boolean hasSuperpower(LivingEntity entity, Power power) {
        return SuperpowerUtil.hasSuperpower(entity, power.getId());
    }

    public static boolean addSuperpower(LivingEntity entity, ResourceLocation powerId) {
        PowerManager powerManager = PowerManager.getInstance(entity.m_9236_());
        if (powerManager.getPower(powerId) == null || SuperpowerUtil.hasSuperpower(entity, powerId)) {
            return false;
        }
        ArrayList<ResourceLocation> powerIds = new ArrayList<ResourceLocation>((Collection)PalladiumProperties.SUPERPOWER_IDS.get((Entity)entity));
        powerIds.add(powerId);
        PalladiumProperties.SUPERPOWER_IDS.set((Entity)entity, powerIds);
        return true;
    }

    public static boolean addSuperpower(LivingEntity entity, Power power) {
        return SuperpowerUtil.addSuperpower(entity, power.getId());
    }

    public static boolean removeSuperpower(LivingEntity entity, ResourceLocation powerId) {
        PowerManager powerManager = PowerManager.getInstance(entity.m_9236_());
        if (powerManager.getPower(powerId) == null || !SuperpowerUtil.hasSuperpower(entity, powerId)) {
            return false;
        }
        ArrayList powerIds = new ArrayList(PalladiumProperties.SUPERPOWER_IDS.get((Entity)entity));
        powerIds.remove(powerId);
        PalladiumProperties.SUPERPOWER_IDS.set((Entity)entity, powerIds);
        return true;
    }

    public static boolean removeSuperpower(LivingEntity entity, Power power) {
        return SuperpowerUtil.removeSuperpower(entity, power.getId());
    }

    public static int removeSuperpowers(LivingEntity entity, Predicate<Power> predicate) {
        ArrayList<Power> toRemove = new ArrayList<Power>();
        for (Power superpower : SuperpowerUtil.getSuperpowers(entity)) {
            if (!predicate.test(superpower)) continue;
            toRemove.add(superpower);
        }
        int i = 0;
        for (Power power : toRemove) {
            if (!SuperpowerUtil.removeSuperpower(entity, power)) continue;
            ++i;
        }
        return i;
    }

    public static int removeSuperpowersByIds(LivingEntity entity, Predicate<ResourceLocation> predicate) {
        ArrayList<ResourceLocation> toRemove = new ArrayList<ResourceLocation>();
        for (ResourceLocation superpower : SuperpowerUtil.getSuperpowerIds(entity)) {
            if (!predicate.test(superpower)) continue;
            toRemove.add(superpower);
        }
        int i = 0;
        for (ResourceLocation power : toRemove) {
            if (!SuperpowerUtil.removeSuperpower(entity, power)) continue;
            ++i;
        }
        return i;
    }

    public static void removeAllSuperpowers(LivingEntity entity) {
        PalladiumProperties.SUPERPOWER_IDS.set((Entity)entity, Collections.emptyList());
    }
}

