/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import com.mojang.blaze3d.shaders.FogShape;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Camera;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FogType;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladiumcore.event.EventResult;
import net.threetag.palladiumcore.event.ViewportEvents;

public class AbilityClientEventHandler
implements ViewportEvents.RenderFog,
ViewportEvents.ComputeFogColor {
    public static void init() {
        AbilityClientEventHandler instance = new AbilityClientEventHandler();
        ViewportEvents.RENDER_FOG.register((Object)instance);
        ViewportEvents.COMPUTE_FOG_COLOR.register((Object)instance);
    }

    public EventResult renderFog(GameRenderer gameRenderer, Camera camera, double partialTick, FogRenderer.FogMode fogMode, FogType fogType, AtomicReference<Float> farPlaneDistance, AtomicReference<Float> nearPlaneDistance, AtomicReference<FogShape> fogShape) {
        LivingEntity living;
        Entity entity = camera.m_90592_();
        if (entity instanceof LivingEntity && AbilityUtil.isTypeEnabled(living = (LivingEntity)entity, (Ability)Abilities.INTANGIBILITY.get()) && AbilityClientEventHandler.getInWallBlockState(living) != null) {
            fogShape.set(FogShape.SPHERE);
            farPlaneDistance.set(Float.valueOf(5.0f));
            nearPlaneDistance.set(Float.valueOf(1.0f));
            return EventResult.cancel();
        }
        return EventResult.pass();
    }

    public static BlockState getInWallBlockState(LivingEntity playerEntity) {
        BlockPos.MutableBlockPos mutable = new BlockPos.MutableBlockPos();
        for (int i = 0; i < 8; ++i) {
            double d = playerEntity.m_20185_() + (double)(((float)(i % 2) - 0.5f) * playerEntity.m_20205_() * 0.8f);
            double e = playerEntity.m_20188_() + (double)(((float)((i >> 1) % 2) - 0.5f) * 0.1f);
            double f = playerEntity.m_20189_() + (double)(((float)((i >> 2) % 2) - 0.5f) * playerEntity.m_20205_() * 0.8f);
            mutable.m_122169_(d, e, f);
            BlockState blockState = playerEntity.m_9236_().m_8055_((BlockPos)mutable);
            if (blockState.m_60799_() == RenderShape.INVISIBLE || !blockState.m_60831_((BlockGetter)playerEntity.m_9236_(), (BlockPos)mutable)) continue;
            return blockState;
        }
        return null;
    }

    public void computeFogColor(GameRenderer gameRenderer, Camera camera, double partialTick, AtomicReference<Float> red, AtomicReference<Float> green, AtomicReference<Float> blue) {
        LivingEntity living;
        Entity entity = camera.m_90592_();
        if (entity instanceof LivingEntity && AbilityUtil.isTypeEnabled(living = (LivingEntity)entity, (Ability)Abilities.INTANGIBILITY.get()) && AbilityClientEventHandler.getInWallBlockState(living) != null) {
            red.set(Float.valueOf(0.0f));
            green.set(Float.valueOf(0.0f));
            blue.set(Float.valueOf(0.0f));
        }
    }
}

