/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Collections;
import java.util.Objects;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.energybeam.EnergyBeamConfiguration;
import net.threetag.palladium.client.energybeam.EnergyBeamManager;
import net.threetag.palladium.entity.effect.EnergyBeamEffect;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AnimationTimer;
import net.threetag.palladium.util.EntityUtil;
import net.threetag.palladium.util.PalladiumBlockUtil;
import net.threetag.palladium.util.property.BooleanProperty;
import net.threetag.palladium.util.property.CommandFunctionProperty;
import net.threetag.palladium.util.property.FloatProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PropertyManager;
import net.threetag.palladium.util.property.ResourceLocationProperty;
import net.threetag.palladium.util.property.SyncType;
import net.threetag.palladium.util.property.Vec3Property;
import net.threetag.palladiumcore.util.Platform;

public class EnergyBeamAbility
extends Ability
implements AnimationTimer,
CommandSource {
    public static final PalladiumProperty<ResourceLocation> BEAM = new ResourceLocationProperty("energy_beam").configurable("Configuration for the look of the beam. Check wiki for information.");
    public static final PalladiumProperty<ResourceLocation> DAMAGE_TYPE = new ResourceLocationProperty("damage_type").configurable("Damage type which is applied when an entity is hit. Uses normal player/mob attack if null/unchanged.");
    public static final PalladiumProperty<Float> DAMAGE = new FloatProperty("damage").configurable("The damage dealt with aiming for entities (per tick)");
    public static final PalladiumProperty<Float> MAX_DISTANCE = new FloatProperty("max_distance").configurable("The maximum distance you can reach with your heat vision");
    public static final PalladiumProperty<Float> SPEED = new FloatProperty("speed").configurable("Speed at which the energy beam extends from the player. Use 0 for instant extension.");
    public static final PalladiumProperty<Integer> SET_ON_FIRE_SECONDS = new IntegerProperty("set_on_fire_seconds").configurable("You can use this to set targeted entities on fire. If set to 0 it will not cause any.");
    public static final PalladiumProperty<Boolean> CAUSE_FIRE = new BooleanProperty("cause_fire").configurable("If enabled, targeted blocks will start to burn (fire will be placed).");
    public static final PalladiumProperty<Boolean> SMELT_BLOCKS = new BooleanProperty("smelt_blocks").configurable("If enabled, targeted blocks will turn into their smelting result (e.g. sand will turn into glass).");
    public static final PalladiumProperty<CommandFunctionProperty.CommandFunctionParsing> COMMANDS_ON_BLOCK_HIT = new CommandFunctionProperty("commands_on_block_hit").sync(SyncType.NONE).disablePersistence().configurable("Sets the commands which get executed when the beam hits an object");
    public static final PalladiumProperty<CommandFunctionProperty.CommandFunctionParsing> COMMANDS_ON_ENTITY_HIT = new CommandFunctionProperty("commands_on_entity_hit").sync(SyncType.NONE).disablePersistence().configurable("Sets the commands which get executed when the beam hits an object");
    public static final PalladiumProperty<Vec3> TARGET = new Vec3Property("distance").sync(SyncType.NONE);
    public static final PalladiumProperty<Float> VALUE = new FloatProperty("value").sync(SyncType.NONE).disablePersistence();
    public static final PalladiumProperty<Float> PREV_VALUE = new FloatProperty("prev_value").sync(SyncType.NONE).disablePersistence();

    public EnergyBeamAbility() {
        this.withProperty(BEAM, new ResourceLocation("example:energy_beam")).withProperty(DAMAGE_TYPE, null).withProperty(DAMAGE, Float.valueOf(5.0f)).withProperty(MAX_DISTANCE, Float.valueOf(30.0f)).withProperty(SPEED, Float.valueOf(0.5f)).withProperty(SET_ON_FIRE_SECONDS, 0).withProperty(CAUSE_FIRE, false).withProperty(SMELT_BLOCKS, false).withProperty(COMMANDS_ON_BLOCK_HIT, new CommandFunctionProperty.CommandFunctionParsing(Collections.emptyList())).withProperty(COMMANDS_ON_ENTITY_HIT, new CommandFunctionProperty.CommandFunctionParsing(Collections.emptyList()));
    }

    @Override
    public void registerUniqueProperties(PropertyManager manager) {
        manager.register(TARGET, Vec3.f_82478_);
        manager.register(VALUE, Float.valueOf(0.0f));
        manager.register(PREV_VALUE, Float.valueOf(0.0f));
    }

    @Override
    public void firstTick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && entity instanceof Player) {
            Player player = (Player)entity;
            if (entry.getProperty(VALUE).floatValue() <= 0.0f && Platform.isClient()) {
                EnergyBeamEffect.start(player, entry.getReference());
            }
        }
    }

    @Override
    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        float speed = entry.getProperty(SPEED).floatValue();
        float value = entry.getProperty(VALUE).floatValue();
        entry.setUniqueProperty(PREV_VALUE, Float.valueOf(value));
        HitResult hit = null;
        boolean active = enabled;
        if (speed > 0.0f) {
            hit = EnergyBeamAbility.updateTargetPos(entity, entry, 1.0f);
            if (entry.isEnabled() && value < 1.0f) {
                value = Math.min(value + speed, 1.0f);
                entry.setUniqueProperty(VALUE, Float.valueOf(value));
            } else if (!entry.isEnabled() && value > 0.0f) {
                value = Math.max(value - speed, 0.0f);
                entry.setUniqueProperty(VALUE, Float.valueOf(value));
            }
            boolean bl = active = value >= 1.0f;
        }
        if (active) {
            if (hit instanceof EntityHitResult) {
                Level customType;
                Float dmg;
                EntityHitResult entityHitResult = (EntityHitResult)hit;
                Integer fireSecs = entry.getProperty(SET_ON_FIRE_SECONDS);
                if (fireSecs > 0) {
                    entityHitResult.m_82443_().m_20254_(fireSecs.intValue());
                }
                if ((dmg = entry.getProperty(DAMAGE)).floatValue() > 0.0f) {
                    DamageSources dmgSources = entity.m_9236_().m_269111_();
                    customType = entry.getProperty(DAMAGE_TYPE);
                    DamageSource damageSrc = dmgSources.m_268998_(customType != null ? ResourceKey.m_135785_((ResourceKey)Registries.f_268580_, (ResourceLocation)customType) : (entity instanceof Player ? DamageTypes.f_268464_ : DamageTypes.f_268566_), (Entity)entity, (Entity)entity);
                    entityHitResult.m_82443_().m_6469_(damageSrc, dmg.floatValue());
                }
                if (Platform.isClient()) {
                    this.spawnParticles(entity.m_9236_(), hit.m_82450_(), entry);
                }
                if ((customType = entity.m_9236_()) instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)customType;
                    CommandSourceStack source = this.createCommandSourceStack(entity, serverLevel, hit.m_82450_());
                    CommandFunction function = entry.getProperty(COMMANDS_ON_ENTITY_HIT).getCommandFunction(entity.m_9236_().m_7654_());
                    if (function != null) {
                        Objects.requireNonNull(entity.m_9236_().m_7654_()).m_129890_().m_136112_(function, source.m_81324_().m_81358_(2));
                    }
                }
            } else if (hit instanceof BlockHitResult) {
                BlockHitResult blockHitResult = (BlockHitResult)hit;
                BlockState blockState = entity.m_9236_().m_8055_(blockHitResult.m_82425_());
                if (!blockState.m_60795_()) {
                    Level serverLevel;
                    if (entry.getProperty(SMELT_BLOCKS).booleanValue()) {
                        SimpleContainer simpleContainer = new SimpleContainer(new ItemStack[]{new ItemStack((ItemLike)blockState.m_60734_())});
                        entity.m_9236_().m_7465_().m_44015_(RecipeType.f_44108_, (Container)simpleContainer, entity.m_9236_()).ifPresent(recipe -> {
                            ItemStack result = recipe.m_5874_((Container)simpleContainer, entity.m_9236_().m_9598_());
                            if (!result.m_41619_() && Block.m_49814_((Item)result.m_41720_()) != Blocks.f_50016_) {
                                entity.m_9236_().m_46597_(blockHitResult.m_82425_(), Block.m_49814_((Item)result.m_41720_()).m_49966_());
                            }
                        });
                        blockState = entity.m_9236_().m_8055_(blockHitResult.m_82425_());
                    }
                    if (entry.getProperty(CAUSE_FIRE).booleanValue() && PalladiumBlockUtil.canBurn(blockState, (BlockGetter)entity.m_9236_(), blockHitResult.m_82425_(), blockHitResult.m_82434_())) {
                        BlockPos pos = blockHitResult.m_82425_().m_121955_(blockHitResult.m_82434_().m_122436_());
                        if (entity.m_9236_().m_46859_(pos)) {
                            entity.m_9236_().m_46597_(pos, Blocks.f_50083_.m_49966_());
                        }
                    }
                    if (Platform.isClient()) {
                        this.spawnParticles(entity.m_9236_(), hit.m_82450_(), entry);
                    }
                    if ((serverLevel = entity.m_9236_()) instanceof ServerLevel) {
                        ServerLevel serverLevel2 = (ServerLevel)serverLevel;
                        CommandSourceStack source = this.createCommandSourceStack(entity, serverLevel2, hit.m_82450_());
                        CommandFunction function = entry.getProperty(COMMANDS_ON_BLOCK_HIT).getCommandFunction(entity.m_9236_().m_7654_());
                        if (function != null) {
                            Objects.requireNonNull(entity.m_9236_().m_7654_()).m_129890_().m_136112_(function, source.m_81324_().m_81358_(2));
                        }
                    }
                }
            }
        }
    }

    public CommandSourceStack createCommandSourceStack(LivingEntity entity, ServerLevel serverLevel, Vec3 position) {
        return new CommandSourceStack((CommandSource)this, position, entity.m_20155_(), serverLevel, 2, entity.m_7755_().getString(), entity.m_5446_(), entity.m_9236_().m_7654_(), (Entity)entity).m_81324_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void spawnParticles(Level level, Vec3 pos, AbilityInstance entry) {
        EnergyBeamConfiguration beam = EnergyBeamManager.INSTANCE.get(entry.getProperty(BEAM));
        if (beam != null) {
            beam.spawnParticles(level, pos);
        }
    }

    public static HitResult updateTargetPos(LivingEntity living, AbilityInstance entry, float partialTick) {
        Vec3 start = living.m_20299_(partialTick);
        Vec3 end = start.m_82549_(EntityUtil.getLookVector((Entity)living, partialTick).m_82490_((double)entry.getProperty(MAX_DISTANCE).floatValue()));
        HitResult endHit = EntityUtil.rayTraceWithEntities((Entity)living, start, end, start.m_82554_(end), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, en -> true);
        entry.setUniqueProperty(TARGET, endHit.m_82450_());
        return endHit;
    }

    @Override
    public float getAnimationValue(AbilityInstance entry, float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)entry.getProperty(PREV_VALUE).floatValue(), (float)entry.getProperty(VALUE).floatValue());
    }

    @Override
    public float getAnimationTimer(AbilityInstance entry, float partialTick, boolean maxedOut) {
        if (maxedOut) {
            return 1.0f;
        }
        return Mth.m_14179_((float)partialTick, (float)entry.getProperty(PREV_VALUE).floatValue(), (float)entry.getProperty(VALUE).floatValue());
    }

    public void m_213846_(Component component) {
    }

    public boolean m_6999_() {
        return false;
    }

    public boolean m_7028_() {
        return false;
    }

    public boolean m_6102_() {
        return false;
    }
}

