/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.awt.Color;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.ColorProperty;
import net.threetag.palladium.util.property.DoubleProperty;
import net.threetag.palladium.util.property.EntityGlowModeProperty;
import net.threetag.palladium.util.property.EntityPropertyHandler;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.StringProperty;

public class EntityGlowAbility
extends Ability {
    public static final PalladiumProperty<Mode> MODE = new EntityGlowModeProperty("mode").configurable("Determines if this ability makes the entity itself glow, or lets you see other entities with their glow effect.");
    public static final PalladiumProperty<Color> COLOR = new ColorProperty("color").configurable("Determines the color of the glow effect. If left empty, it will use the default team color.");
    public static final PalladiumProperty<Double> DISTANCE = new DoubleProperty("distance").configurable("The distance at which the glow effect is visible. If left empty, it will behave normally.");
    public static final PalladiumProperty<String> PROPERTY_KEY = new StringProperty("property_key").configurable("If you want to make the glow dependent on a Palladium Property, this is the key/name of it which you can specify.");
    public static final PalladiumProperty<String> PROPERTY_VALUE = new StringProperty("property_value").configurable("If you want to make the glow dependent on a Palladium Property, this is value of it which you can specify.");

    public EntityGlowAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_151079_)).withProperty(MODE, Mode.SELF).withProperty(COLOR, null).withProperty(DISTANCE, 0.0).withProperty(PROPERTY_KEY, null).withProperty(PROPERTY_VALUE, null);
    }

    @Override
    public String getDocumentationDescription() {
        return "Makes the entity, the entities visible for you, glow.";
    }

    public static boolean shouldGlow(Entity renderedEntity, Entity cameraEntity) {
        LivingEntity living;
        if (renderedEntity instanceof LivingEntity) {
            living = (LivingEntity)renderedEntity;
            for (AbilityInstance ability : AbilityUtil.getEnabledInstances(living, (Ability)Abilities.ENTITY_GLOW.get())) {
                if (ability.getProperty(MODE) != Mode.SELF || !EntityGlowAbility.propertyCheck(renderedEntity, ability.getProperty(PROPERTY_KEY), ability.getProperty(PROPERTY_VALUE))) continue;
                double maxDistance = ability.getProperty(DISTANCE);
                return maxDistance <= 0.0 || renderedEntity == cameraEntity || renderedEntity.m_20280_(cameraEntity) <= maxDistance * maxDistance;
            }
        }
        if (renderedEntity != cameraEntity && cameraEntity instanceof LivingEntity) {
            living = (LivingEntity)cameraEntity;
            for (AbilityInstance ability : AbilityUtil.getEnabledInstances(living, (Ability)Abilities.ENTITY_GLOW.get())) {
                if (ability.getProperty(MODE) != Mode.OTHERS || !EntityGlowAbility.propertyCheck(renderedEntity, ability.getProperty(PROPERTY_KEY), ability.getProperty(PROPERTY_VALUE))) continue;
                double maxDistance = ability.getProperty(DISTANCE);
                return maxDistance <= 0.0 || renderedEntity.m_20280_(cameraEntity) <= maxDistance * maxDistance;
            }
        }
        return false;
    }

    private static boolean propertyCheck(Entity entity, String key, String value) {
        if (key == null || value == null) {
            return true;
        }
        AtomicBoolean result = new AtomicBoolean(false);
        EntityPropertyHandler.getHandler(entity).ifPresent(handler -> {
            Object val;
            PalladiumProperty<?> prop = handler.getPropertyByName(key);
            if (prop != null && (val = handler.get(prop)) != null) {
                result.set(val.toString().equals(value));
            }
        });
        return result.get();
    }

    public static enum Mode {
        SELF("self"),
        OTHERS("others");

        public final String name;

        private Mode(String name) {
            this.name = name;
        }
    }
}

