/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Collections;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.threetag.palladium.power.IPowerHolder;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.PlayerSlot;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.PlayerSlotListProperty;
import net.threetag.palladium.util.property.SyncType;

public class RestrictSlotsAbility
extends Ability {
    public static final PalladiumProperty<List<PlayerSlot>> SLOTS = new PlayerSlotListProperty("slots").sync(SyncType.NONE).configurable("Slot(s) that will not be able to contain items anymore.");

    public RestrictSlotsAbility() {
        this.withProperty(SLOTS, Collections.singletonList(PlayerSlot.get(EquipmentSlot.CHEST)));
    }

    @Override
    public void tick(LivingEntity entity, AbilityInstance entry, IPowerHolder holder, boolean enabled) {
        if (enabled && !entity.m_9236_().f_46443_) {
            for (PlayerSlot slot : entry.getProperty(SLOTS)) {
                List<ItemStack> items = slot.getItems(entity);
                slot.clear(entity);
                for (ItemStack item : items) {
                    if (item.m_41619_()) continue;
                    this.drop(entity, item, slot);
                }
            }
        }
    }

    public void drop(LivingEntity entity, ItemStack stack, PlayerSlot slot) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!player.m_150109_().m_36054_(stack)) {
                player.m_36176_(stack, true);
            }
        } else {
            entity.m_19983_(stack);
        }
    }

    public static boolean isRestricted(LivingEntity entity, EquipmentSlot slot) {
        for (AbilityInstance entry : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.RESTRICT_SLOTS.get())) {
            for (PlayerSlot playerSlot : entry.getProperty(SLOTS)) {
                if (playerSlot.getEquipmentSlot() != slot) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isRestricted(LivingEntity entity, String key) {
        for (AbilityInstance entry : AbilityUtil.getEnabledEntries(entity, (Ability)Abilities.RESTRICT_SLOTS.get())) {
            for (PlayerSlot playerSlot : entry.getProperty(SLOTS)) {
                if (!playerSlot.toString().equalsIgnoreCase(key)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public String getDocumentationDescription() {
        return "Let's you restrict the slots that can be used by the player. It will drop the items if disabled while the player has items in the restricted slots.";
    }
}

