/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.List;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.client.renderer.entity.PlayerSkinHandler;
import net.threetag.palladium.power.ability.Abilities;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.power.ability.AbilityUtil;
import net.threetag.palladium.util.SkinTypedValue;
import net.threetag.palladium.util.context.DataContext;
import net.threetag.palladium.util.property.ChangedPlayerModelTypeProperty;
import net.threetag.palladium.util.property.IntegerProperty;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.SkinTypedTextureReferenceProperty;

public class SkinChangeAbility
extends Ability {
    public static final PalladiumProperty<SkinTypedValue<TextureReference>> TEXTURE = new SkinTypedTextureReferenceProperty("texture").configurable("Texture for the skin change");
    public static final PalladiumProperty<ChangedPlayerModelTypeProperty.ChangedModelType> MODEL_TYPE = new ChangedPlayerModelTypeProperty("model_type").configurable("Model type for the player. 'normal' = Wide-armed Steve model; 'slim' = Slim-armed Alex model; 'keep' = Does not change the player's default model");
    public static final PalladiumProperty<Integer> PRIORITY = new IntegerProperty("priority").configurable("Priority for the skin (in case multiple skin changes are applied, the one with the highest priority will be used)");

    public SkinChangeAbility() {
        this.withProperty(TEXTURE, new SkinTypedValue<TextureReference>(TextureReference.normal(new ResourceLocation("textures/entity/zombie/drowned.png"))));
        this.withProperty(MODEL_TYPE, ChangedPlayerModelTypeProperty.ChangedModelType.KEEP);
        this.withProperty(PRIORITY, 50);
    }

    @Override
    public boolean isEffect() {
        return true;
    }

    @Override
    public String getDocumentationDescription() {
        return "Allows you to change a player's skin.";
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class SkinProvider
    implements PlayerSkinHandler.ISkinProvider {
        @Override
        public ResourceLocation getSkin(AbstractClientPlayer player, ResourceLocation previousSkin, ResourceLocation defaultSkin) {
            List<AbilityInstance> abilities = AbilityUtil.getEnabledEntries((LivingEntity)player, (Ability)Abilities.SKIN_CHANGE.get()).stream().filter(AbilityInstance::isEnabled).sorted((a1, a2) -> a2.getProperty(PRIORITY) - a1.getProperty(PRIORITY)).toList();
            if (!abilities.isEmpty()) {
                AbilityInstance ability = abilities.get(0);
                return ability.getProperty(TEXTURE).get((Entity)player).getTexture(DataContext.forAbility((LivingEntity)player, ability));
            }
            return previousSkin;
        }

        @Override
        public ChangedPlayerModelTypeProperty.ChangedModelType getModelType(AbstractClientPlayer player) {
            List<AbilityInstance> abilities = AbilityUtil.getEnabledEntries((LivingEntity)player, (Ability)Abilities.SKIN_CHANGE.get()).stream().filter(AbilityInstance::isEnabled).sorted((a1, a2) -> a2.getProperty(PRIORITY) - a1.getProperty(PRIORITY)).toList();
            if (!abilities.isEmpty()) {
                AbilityInstance ability = abilities.get(0);
                return ability.getProperty(MODEL_TYPE);
            }
            return PlayerSkinHandler.ISkinProvider.super.getModelType(player);
        }
    }
}

