/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.power.ability;

import java.util.Arrays;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.threetag.palladium.power.ability.Ability;
import net.threetag.palladium.power.ability.AbilityInstance;
import net.threetag.palladium.util.icon.ItemIcon;
import net.threetag.palladium.util.property.PalladiumProperty;
import net.threetag.palladium.util.property.TagKeyListProperty;

public class ToolHandsAbility
extends Ability {
    public static final PalladiumProperty<List<TagKey<Block>>> DROP_BLOCK_TAGS = new TagKeyListProperty("drop_block_tags", Registries.f_256747_).configurable("Blocks in these tags will be dropped when mined");

    public ToolHandsAbility() {
        this.withProperty(ICON, new ItemIcon((ItemLike)Items.f_42422_));
        this.withProperty(DROP_BLOCK_TAGS, Arrays.asList(BlockTags.f_144282_, BlockTags.f_144285_));
    }

    public static boolean blockDrops(AbilityInstance instance, BlockState blockState) {
        if (!instance.isEnabled()) {
            return false;
        }
        for (TagKey<Block> blockTag : instance.getProperty(DROP_BLOCK_TAGS)) {
            if (!blockState.m_204336_(blockTag)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDocumentationDescription() {
        return "Allows the player to mine a block and receive its drops as if a tool were used";
    }
}

