/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import it.unimi.dsi.fastutil.floats.Float2FloatFunction;

public enum Easing {
    LINEAR(f -> f),
    CONSTANT(f -> 0.0f),
    INSINE(Easing::inSine),
    OUTSINE(Easing::outSine),
    INOUTSINE(Easing::inOutSine),
    INCUBIC(Easing::inCubic),
    OUTCUBIC(Easing::outCubic),
    INOUTCUBIC(Easing::inOutCubic),
    INQUAD(Easing::inQuad),
    OUTQUAD(Easing::outQuad),
    INOUTQUAD(Easing::inOutQuad),
    INQUART(Easing::inQuart),
    OUTQUART(Easing::outQuart),
    INOUTQUART(Easing::inOutQuart),
    INQUINT(Easing::inQuint),
    OUTQUINT(Easing::outQuint),
    INOUTQUINT(Easing::inOutQuint),
    INEXPO(Easing::inExpo),
    OUTEXPO(Easing::outExpo),
    INOUTEXPO(Easing::inOutExpo),
    INCIRC(Easing::inCirc),
    OUTCIRC(Easing::outCirc),
    INOUTCIRC(Easing::inOutCirc),
    INBACK(Easing::inBack),
    OUTBACK(Easing::outBack),
    INOUTBACK(Easing::inOutBack),
    INELASTIC(Easing::inElastic),
    OUTELASTIC(Easing::outElastic),
    INOUTELASTIC(Easing::inOutElastic),
    INBOUNCE(Easing::inBounce),
    OUTBOUNCE(Easing::outBack),
    INOUTBOUNCE(Easing::inOutBounce);

    private final Float2FloatFunction function;
    private static final float c1 = 1.70158f;
    private static final float c2 = 2.5949094f;
    private static final float c3 = 2.70158f;
    private static final float c4 = 2.0943952f;
    private static final float c5 = 1.3962634f;
    private static final float n1 = 7.5625f;
    private static final float d1 = 2.75f;

    private Easing(Float2FloatFunction function) {
        this.function = function;
    }

    public float apply(float f) {
        return ((Float)this.function.apply((Object)Float.valueOf(f))).floatValue();
    }

    public static Easing fromString(String string) {
        try {
            if (string.equals("step")) {
                return CONSTANT;
            }
            if (string.substring(0, 4).equalsIgnoreCase("EASE")) {
                string = string.substring(4);
            }
            return Easing.valueOf(string.toUpperCase());
        }
        catch (Exception exception) {
            return LINEAR;
        }
    }

    public static float applyFromString(String string, float f) {
        return Easing.fromString(string).apply(f);
    }

    public static float inSine(float f) {
        return (float)(1.0 - Math.cos((double)f * Math.PI / 2.0));
    }

    public static float outSine(float f) {
        return (float)Math.sin((double)f * Math.PI / 2.0);
    }

    public static float inOutSine(float f) {
        return (float)(-(Math.cos(Math.PI * (double)f) - 1.0) / 2.0);
    }

    public static float inCubic(float f) {
        return f * f * f;
    }

    public static float outCubic(float f) {
        return (float)(1.0 - Math.pow(1.0f - f, 3.0));
    }

    public static float inOutCubic(float x) {
        return (float)((double)x < 0.5 ? (double)(4.0f * x * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 3.0) / 2.0);
    }

    public static float inQuad(float x) {
        return x * x;
    }

    public static float outQuad(float x) {
        return 1.0f - (1.0f - x) * (1.0f - x);
    }

    public static float inOutQuad(float x) {
        return (float)((double)x < 0.5 ? (double)(2.0f * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 2.0) / 2.0);
    }

    public static float inQuart(float x) {
        return x * x * x * x;
    }

    public static float outQuart(float x) {
        return (float)(1.0 - Math.pow(1.0f - x, 4.0));
    }

    public static float inOutQuart(float x) {
        return (float)((double)x < 0.5 ? (double)(8.0f * x * x * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 4.0) / 2.0);
    }

    public static float inQuint(float x) {
        return x * x * x * x * x;
    }

    public static float outQuint(float x) {
        return (float)(1.0 - Math.pow(1.0f - x, 5.0));
    }

    public static float inOutQuint(float x) {
        return (float)((double)x < 0.5 ? (double)(16.0f * x * x * x * x * x) : 1.0 - Math.pow(-2.0f * x + 2.0f, 5.0) / 2.0);
    }

    public static float inExpo(float x) {
        return (float)(x == 0.0f ? 0.0 : Math.pow(2.0, 10.0f * x - 10.0f));
    }

    public static float outExpo(float x) {
        return (float)(x == 1.0f ? 1.0 : 1.0 - Math.pow(2.0, -10.0f * x));
    }

    public static float inOutExpo(float x) {
        return (float)(x == 0.0f ? 0.0 : (x == 1.0f ? 1.0 : ((double)x < 0.5 ? Math.pow(2.0, 20.0f * x - 10.0f) / 2.0 : (2.0 - Math.pow(2.0, -20.0f * x + 10.0f)) / 2.0)));
    }

    public static float inCirc(float x) {
        return (float)(1.0 - Math.sqrt(1.0 - Math.pow(x, 2.0)));
    }

    public static float outCirc(float x) {
        return (float)Math.sqrt(1.0 - Math.pow(x - 1.0f, 2.0));
    }

    public static float inOutCirc(float x) {
        return (float)((double)x < 0.5 ? (1.0 - Math.sqrt(1.0 - Math.pow(2.0f * x, 2.0))) / 2.0 : (Math.sqrt(1.0 - Math.pow(-2.0f * x + 2.0f, 2.0)) + 1.0) / 2.0);
    }

    public static float inBack(float x) {
        return 2.70158f * x * x * x - 1.70158f * x * x;
    }

    public static float outBack(float x) {
        return (float)(1.0 + (double)2.70158f * Math.pow(x - 1.0f, 3.0) + (double)1.70158f * Math.pow(x - 1.0f, 2.0));
    }

    public static float inOutBack(float x) {
        return (float)((double)x < 0.5 ? Math.pow(2.0f * x, 2.0) * (double)(7.189819f * x - 2.5949094f) / 2.0 : (Math.pow(2.0f * x - 2.0f, 2.0) * (double)(3.5949094f * (x * 2.0f - 2.0f) + 2.5949094f) + 2.0) / 2.0);
    }

    public static float inElastic(float x) {
        return (float)(x == 0.0f ? 0.0 : (x == 1.0f ? 1.0 : -Math.pow(2.0, 10.0f * x - 10.0f) * Math.sin(((double)(x * 10.0f) - 10.75) * 2.094395160675049)));
    }

    public static float outElastic(float x) {
        return (float)(x == 0.0f ? 0.0 : (x == 1.0f ? 1.0 : Math.pow(2.0, -10.0f * x) * Math.sin(((double)(x * 10.0f) - 0.75) * 2.094395160675049) + 1.0));
    }

    public static float inOutElastic(float x) {
        return (float)(x == 0.0f ? 0.0 : (x == 1.0f ? 1.0 : ((double)x < 0.5 ? -(Math.pow(2.0, 20.0f * x - 10.0f) * Math.sin(((double)(20.0f * x) - 11.125) * 1.3962633609771729)) / 2.0 : Math.pow(2.0, -20.0f * x + 10.0f) * Math.sin(((double)(20.0f * x) - 11.125) * 1.3962633609771729) / 2.0 + 1.0)));
    }

    public static float inBounce(float x) {
        return 1.0f - Easing.outBounce(1.0f - x);
    }

    public static float outBounce(float x) {
        if (x < 0.36363637f) {
            return 7.5625f * x * x;
        }
        if (x < 0.72727275f) {
            x = (float)((double)x - 0.5454545454545454);
            return (float)((double)(7.5625f * x * x) + 0.75);
        }
        if ((double)x < 0.9090909090909091) {
            x = (float)((double)x - 0.8181818181818182);
            return (float)((double)(7.5625f * x * x) + 0.9375);
        }
        x = (float)((double)x - 0.9545454545454546);
        return (float)((double)(7.5625f * x * x) + 0.984375);
    }

    public static float inOutBounce(float x) {
        return (double)x < 0.5 ? (1.0f - Easing.outBounce(1.0f - 2.0f * x)) / 2.0f : (1.0f + Easing.outBounce(2.0f * x - 1.0f)) / 2.0f;
    }
}

