/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PerspectiveValue<T> {
    private final T firstPerson;
    private final T thirdPerson;

    public PerspectiveValue(T value) {
        this.thirdPerson = value;
        this.firstPerson = this.thirdPerson;
    }

    public PerspectiveValue(T firstPerson, T thirdPerson) {
        this.firstPerson = firstPerson;
        this.thirdPerson = thirdPerson;
    }

    public T getFirstPerson() {
        return this.firstPerson;
    }

    public T getThirdPerson() {
        return this.thirdPerson;
    }

    public T get(boolean firstPerson) {
        return firstPerson ? this.getFirstPerson() : this.getThirdPerson();
    }

    @OnlyIn(value=Dist.CLIENT)
    public T get(CameraType cameraType) {
        return this.get(cameraType == CameraType.FIRST_PERSON);
    }

    @OnlyIn(value=Dist.CLIENT)
    public T get() {
        return this.get(Minecraft.m_91087_().f_91066_.m_92176_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public T getForPlayer(Player player) {
        if (player == Minecraft.m_91087_().f_91074_) {
            return this.get();
        }
        return this.get(false);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerspectiveValue)) {
            return false;
        }
        PerspectiveValue that = (PerspectiveValue)o;
        return Objects.equals(this.firstPerson, that.firstPerson) && Objects.equals(this.thirdPerson, that.thirdPerson);
    }

    public int hashCode() {
        return Objects.hash(this.firstPerson, this.thirdPerson);
    }

    public String toString() {
        return "PerspectiveValue{firstPerson=" + String.valueOf(this.firstPerson) + ", thirdPerson=" + String.valueOf(this.thirdPerson) + "}";
    }

    public static <T> PerspectiveValue<T> fromJSON(JsonElement jsonElement, Function<JsonElement, T> parser) {
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            if (GsonHelper.m_13900_((JsonObject)json, (String)"first_person") && GsonHelper.m_13900_((JsonObject)json, (String)"third_person")) {
                return new PerspectiveValue<T>(parser.apply(json.get("first_person")), parser.apply(json.get("third_person")));
            }
            return new PerspectiveValue<T>(parser.apply(jsonElement));
        }
        return new PerspectiveValue<T>(parser.apply(jsonElement));
    }

    public static <T> PerspectiveValue<T> getFromJson(JsonObject json, String memberName, Function<JsonElement, T> parser, T fallback) {
        if (json.has(memberName)) {
            return PerspectiveValue.fromJSON(json.get(memberName), parser);
        }
        return new PerspectiveValue<T>(fallback);
    }

    public JsonElement toJson(Function<T, JsonElement> serializer) {
        if (this.firstPerson == this.thirdPerson) {
            return serializer.apply(this.firstPerson);
        }
        JsonObject json = new JsonObject();
        json.add("first_person", serializer.apply(this.firstPerson));
        json.add("third_person", serializer.apply(this.thirdPerson));
        return json;
    }
}

