/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.threetag.palladium.accessory.AccessorySlot;
import net.threetag.palladium.client.dynamictexture.TextureReference;
import net.threetag.palladium.power.ability.AbilityReference;
import net.threetag.palladium.power.energybar.EnergyBarReference;
import net.threetag.palladium.util.ModelLayerLocationUtil;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class GsonUtil {
    public static int[] getIntArray(JsonObject jsonObject, int fields, String key) {
        if (!GsonHelper.m_13900_((JsonObject)jsonObject, (String)key)) {
            throw new JsonSyntaxException("Missing " + key + ", expected to find a JsonArray");
        }
        JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)key);
        if (jsonArray.size() != fields) {
            throw new JsonParseException("Array " + key + " must have " + fields + " entries!");
        }
        int[] array = new int[fields];
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = jsonArray.get(i).getAsInt();
        }
        return array;
    }

    public static int[] getIntArray(JsonObject jsonObject, int fields, String key, int ... fallback) {
        if (!GsonHelper.m_13900_((JsonObject)jsonObject, (String)key)) {
            return fallback;
        }
        return GsonUtil.getIntArray(jsonObject, fields, key);
    }

    public static float[] getFloatArray(JsonObject jsonObject, int fields, String key) {
        if (!GsonHelper.m_13900_((JsonObject)jsonObject, (String)key)) {
            throw new JsonSyntaxException("Missing " + key + ", expected to find a JsonArray");
        }
        JsonArray jsonArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)key);
        if (jsonArray.size() != fields) {
            throw new JsonParseException("Array " + key + " must have " + fields + " entries!");
        }
        float[] array = new float[fields];
        for (int i = 0; i < jsonArray.size(); ++i) {
            array[i] = jsonArray.get(i).getAsFloat();
        }
        return array;
    }

    public static float[] getFloatArray(JsonObject jsonObject, int fields, String key, float ... fallback) {
        if (!GsonHelper.m_13900_((JsonObject)jsonObject, (String)key)) {
            return fallback;
        }
        return GsonUtil.getFloatArray(jsonObject, fields, key);
    }

    public static ItemStack getAsItemStack(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return GsonUtil.readItemStack(json.get(memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an itemstack");
    }

    public static ItemStack getAsItemStack(JsonObject json, String memberName, @Nullable ItemStack fallback) {
        return json.has(memberName) ? GsonUtil.getAsItemStack(json, memberName) : fallback;
    }

    public static ResourceLocation convertToResourceLocation(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return new ResourceLocation(json.getAsString());
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a resource location, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    public static ResourceLocation getAsResourceLocation(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a resource location");
    }

    public static ResourceLocation getAsResourceLocation(JsonObject json, String memberName, @Nullable ResourceLocation fallback) {
        return json.has(memberName) ? GsonUtil.getAsResourceLocation(json, memberName) : fallback;
    }

    public static TextureReference convertToTextureReference(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return TextureReference.parse(json.getAsString());
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a texture reference, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    public static TextureReference getAsTextureReference(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return TextureReference.parse(GsonHelper.m_13906_((JsonObject)json, (String)memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a texture referenc");
    }

    public static TextureReference getAsTextureReference(JsonObject json, String memberName, @Nullable TextureReference fallback) {
        return json.has(memberName) ? GsonUtil.getAsTextureReference(json, memberName) : fallback;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ModelLayerLocation convertToModelLayerLocation(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            String[] s = json.getAsString().split("#", 2);
            if (s.length == 1) {
                return new ModelLayerLocation(new ResourceLocation(s[0]), "main");
            }
            return new ModelLayerLocation(new ResourceLocation(s[0]), s[1]);
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a model layer location, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ModelLayerLocation getAsModelLayerLocation(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            String[] s = GsonHelper.m_13906_((JsonObject)json, (String)memberName).split("#", 2);
            if (s.length == 1) {
                return new ModelLayerLocation(new ResourceLocation(s[0]), "main");
            }
            return new ModelLayerLocation(new ResourceLocation(s[0]), s[1]);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a model layer location");
    }

    @OnlyIn(value=Dist.CLIENT)
    public static ModelLayerLocation getAsModelLayerLocation(JsonObject json, String memberName, @Nullable ModelLayerLocation fallback) {
        return json.has(memberName) ? GsonUtil.getAsModelLayerLocation(json, memberName) : fallback;
    }

    public static ModelLayerLocationUtil convertToModelLayerLocationUtil(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            String[] s = json.getAsString().split("#", 2);
            if (s.length == 1) {
                return new ModelLayerLocationUtil(new ResourceLocation(s[0]), "main");
            }
            return new ModelLayerLocationUtil(new ResourceLocation(s[0]), s[1]);
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be a model layer location, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    public static ModelLayerLocationUtil getAsModelLayerLocationUtil(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            String[] s = GsonHelper.m_13906_((JsonObject)json, (String)memberName).split("#", 2);
            if (s.length == 1) {
                return new ModelLayerLocationUtil(new ResourceLocation(s[0]), "main");
            }
            return new ModelLayerLocationUtil(new ResourceLocation(s[0]), s[1]);
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a model layer location");
    }

    public static ModelLayerLocationUtil getAsModelLayerLocationUtil(JsonObject json, String memberName, @Nullable ModelLayerLocationUtil fallback) {
        return json.has(memberName) ? GsonUtil.getAsModelLayerLocationUtil(json, memberName) : fallback;
    }

    public static AbilityReference convertToAbilityReference(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return AbilityReference.fromString(json.getAsString());
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an ability reference, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    public static AbilityReference getAsAbilityReference(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return AbilityReference.fromString(GsonHelper.m_13906_((JsonObject)json, (String)memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an ability reference");
    }

    public static AbilityReference getAsAbilityReference(JsonObject json, String memberName, @Nullable AbilityReference fallback) {
        return json.has(memberName) ? GsonUtil.getAsAbilityReference(json, memberName) : fallback;
    }

    public static EnergyBarReference convertToEnergyBarReference(JsonElement json, String memberName) {
        if (json.isJsonPrimitive()) {
            return EnergyBarReference.fromString(json.getAsString());
        }
        throw new JsonSyntaxException("Expected " + memberName + " to be an energy bar reference, was " + GsonHelper.m_13883_((JsonElement)json));
    }

    public static EnergyBarReference getAsEnergyBarReference(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return EnergyBarReference.fromString(GsonHelper.m_13906_((JsonObject)json, (String)memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an energy bar reference");
    }

    public static EnergyBarReference getAsEnergyBarReference(JsonObject json, String memberName, @Nullable EnergyBarReference fallback) {
        return json.has(memberName) ? GsonUtil.getAsEnergyBarReference(json, memberName) : fallback;
    }

    public static UUID getAsUUID(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return UUID.fromString(GsonHelper.m_13906_((JsonObject)json, (String)memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a UUID string");
    }

    public static UUID getAsUUID(JsonObject json, String memberName, @Nullable UUID fallback) {
        return json.has(memberName) ? GsonUtil.getAsUUID(json, memberName) : fallback;
    }

    public static int getAsIntRanged(JsonObject json, String memberName, int min, int max, int fallback) {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return fallback;
        }
        return GsonUtil.getAsIntRanged(json, memberName, min, max);
    }

    public static int getAsIntRanged(JsonObject json, String memberName, int min, int max) {
        int i = GsonHelper.m_13927_((JsonObject)json, (String)memberName);
        if (i < min || i > max) {
            throw new JsonParseException("Expected " + memberName + " to be within bounds " + min + " ~ " + max);
        }
        return i;
    }

    public static int getAsIntMin(JsonObject json, String memberName, int min, int fallback) {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return fallback;
        }
        return GsonUtil.getAsIntMin(json, memberName, min);
    }

    public static int getAsIntMin(JsonObject json, String memberName, int min) {
        int i = GsonHelper.m_13927_((JsonObject)json, (String)memberName);
        if (i < min) {
            throw new JsonParseException("Expected " + memberName + " to be greater than or equals " + min);
        }
        return i;
    }

    public static int getAsIntMax(JsonObject json, String memberName, int max, int fallback) {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return fallback;
        }
        return GsonUtil.getAsIntMax(json, memberName, max);
    }

    public static int getAsIntMax(JsonObject json, String memberName, int max) {
        int i = GsonHelper.m_13927_((JsonObject)json, (String)memberName);
        if (i > max) {
            throw new JsonParseException("Expected " + memberName + " to be less then or equals " + max);
        }
        return i;
    }

    public static float getAsFloatRanged(JsonObject json, String memberName, float min, float max, float fallback) {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return fallback;
        }
        return GsonUtil.getAsFloatRanged(json, memberName, min, max);
    }

    public static float getAsFloatRanged(JsonObject json, String memberName, float min, float max) {
        float f = GsonHelper.m_13915_((JsonObject)json, (String)memberName);
        if (f < min || f > max) {
            throw new JsonParseException("Expected " + memberName + " to be within bounds " + min + " ~ " + max);
        }
        return f;
    }

    public static float getAsFloatMin(JsonObject json, String memberName, float min, float fallback) {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return fallback;
        }
        return GsonUtil.getAsFloatMin(json, memberName, min);
    }

    public static float getAsFloatMin(JsonObject json, String memberName, float min) {
        float f = GsonHelper.m_13915_((JsonObject)json, (String)memberName);
        if (f < min) {
            throw new JsonParseException("Expected " + memberName + " to be greater than or equals " + min);
        }
        return f;
    }

    public static float getAsFloatMax(JsonObject json, String memberName, float max, float fallback) {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return fallback;
        }
        return GsonUtil.getAsFloatMax(json, memberName, max);
    }

    public static float getAsFloatMax(JsonObject json, String memberName, float max) {
        float f = GsonHelper.m_13915_((JsonObject)json, (String)memberName);
        if (f > max) {
            throw new JsonParseException("Expected " + memberName + " to be less then or equals " + max);
        }
        return f;
    }

    public static Component getAsComponent(JsonObject json, String memberName) {
        if (GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return Component.Serializer.m_130691_((JsonElement)json.get(memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a Text Component definition");
    }

    public static Component getAsComponent(JsonObject json, String memberName, Component fallback) {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return fallback;
        }
        return GsonUtil.getAsComponent(json, memberName);
    }

    public static List<Component> getAsComponentList(JsonObject json, String memberName) {
        if (GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            if (json.get(memberName).isJsonPrimitive() || json.get(memberName).isJsonObject()) {
                return List.of((Component)Objects.requireNonNull(Component.Serializer.m_130691_((JsonElement)json.get(memberName))));
            }
            JsonArray array = GsonHelper.m_13924_((JsonElement)json.get(memberName), (String)memberName);
            ArrayList<Component> list = new ArrayList<Component>();
            for (int i = 0; i < array.size(); ++i) {
                list.add((Component)Component.Serializer.m_130691_((JsonElement)array.get(i)));
            }
            return list;
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a String, a JsonObject, or an array of Text Component definitions");
    }

    public static List<Component> getAsComponentList(JsonObject json, String memberName, List<Component> fallback) {
        if (!GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            return fallback;
        }
        return GsonUtil.getAsComponentList(json, memberName);
    }

    public static Color convertToColor(JsonElement element) {
        if (element.isJsonPrimitive()) {
            return Color.decode(element.getAsString());
        }
        if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            if (array.size() == 3) {
                return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
            }
            if (array.size() == 4) {
                return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt(), array.get(3).getAsInt());
            }
            throw new JsonParseException("Color array must either have 3 (RGB) or 4 (RGBA) integers");
        }
        throw new JsonParseException("Color must either be defined as RGB-string or array of integers");
    }

    public static Color getAsColor(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            JsonElement jsonElement = json.get(memberName);
            if (jsonElement.isJsonPrimitive()) {
                return Color.decode(jsonElement.getAsString());
            }
            if (jsonElement.isJsonArray()) {
                JsonArray array = jsonElement.getAsJsonArray();
                if (array.size() == 3) {
                    return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt());
                }
                if (array.size() == 4) {
                    return new Color(array.get(0).getAsInt(), array.get(1).getAsInt(), array.get(2).getAsInt(), array.get(3).getAsInt());
                }
                throw new JsonParseException("Color array must either have 3 (RGB) or 4 (RGBA) integers");
            }
            throw new JsonParseException("Color must either be defined as RGB-string or array of integers");
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a color");
    }

    public static Color getAsColor(JsonObject json, String memberName, @Nullable Color fallback) {
        return json.has(memberName) ? GsonUtil.getAsColor(json, memberName) : fallback;
    }

    public static Object getAsRawColor(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            JsonElement jsonElement = json.get(memberName);
            if (jsonElement.isJsonPrimitive()) {
                return jsonElement.getAsString();
            }
            if (jsonElement.isJsonArray()) {
                JsonArray array = jsonElement.getAsJsonArray();
                Function<JsonPrimitive, Object> parse = js -> {
                    if (js.isString()) {
                        return js.getAsString();
                    }
                    return js.getAsInt();
                };
                if (array.size() == 3) {
                    return new Object[]{parse.apply(array.get(0).getAsJsonPrimitive()), parse.apply(array.get(1).getAsJsonPrimitive()), parse.apply(array.get(2).getAsJsonPrimitive())};
                }
                if (array.size() == 4) {
                    return new Object[]{parse.apply(array.get(0).getAsJsonPrimitive()), parse.apply(array.get(1).getAsJsonPrimitive()), parse.apply(array.get(2).getAsJsonPrimitive()), parse.apply(array.get(3).getAsJsonPrimitive())};
                }
                throw new JsonParseException("Color array must either have 3 (RGB) or 4 (RGBA) integers");
            }
            throw new JsonParseException("Color must either be defined as RGB-string or array of integers");
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a color");
    }

    public static Object getAsRawColor(JsonObject json, String memberName, @Nullable Object fallback) {
        return json.has(memberName) ? GsonUtil.getAsRawColor(json, memberName) : fallback;
    }

    @Nullable
    public static AccessorySlot getAsAccessorySlot(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            return AccessorySlot.getSlotByName(GsonUtil.getAsResourceLocation(json, memberName));
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find an accessory slot");
    }

    public static Vector3f getAsVector3f(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            if (json.get(memberName).isJsonArray()) {
                JsonArray array = json.get(memberName).getAsJsonArray();
                if (array.size() != 3) {
                    throw new JsonSyntaxException(memberName + " must have 3 floats");
                }
                return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
            }
            throw new JsonSyntaxException(memberName + " must be an array to represent a 3-dimensional vector");
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a vector");
    }

    public static Vector3f getAsVector3f(JsonObject json, String memberName, Vector3f fallback) {
        return json.has(memberName) ? GsonUtil.getAsVector3f(json, memberName) : fallback;
    }

    public static Vector3f convertToVector3f(JsonElement jsonElement, String memberName) {
        if (jsonElement.isJsonArray()) {
            JsonArray array = jsonElement.getAsJsonArray();
            if (array.size() != 3) {
                throw new JsonSyntaxException(memberName + " must have 3 floats");
            }
            return new Vector3f(array.get(0).getAsFloat(), array.get(1).getAsFloat(), array.get(2).getAsFloat());
        }
        throw new JsonSyntaxException(memberName + " must be an array to represent a 3-dimensional vector");
    }

    public static Vec3 getAsVec3(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            if (json.get(memberName).isJsonArray()) {
                JsonArray array = json.get(memberName).getAsJsonArray();
                if (array.size() != 3) {
                    throw new JsonSyntaxException(memberName + " must have 3 doubles");
                }
                return new Vec3(array.get(0).getAsDouble(), array.get(1).getAsDouble(), array.get(2).getAsDouble());
            }
            throw new JsonSyntaxException(memberName + " must be an array to represent a 3-dimensional vector");
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a vector");
    }

    public static Vec3 getAsVec3(JsonObject json, String memberName, Vec3 fallback) {
        return json.has(memberName) ? GsonUtil.getAsVec3(json, memberName) : fallback;
    }

    public static float getAsBooleanFloat(JsonObject json, String memberName) {
        if (json.has(memberName)) {
            if (json.get(memberName).isJsonPrimitive()) {
                JsonPrimitive primitive = json.get(memberName).getAsJsonPrimitive();
                if (primitive.isBoolean()) {
                    return primitive.getAsBoolean() ? 1.0f : 0.0f;
                }
                return primitive.getAsFloat();
            }
            throw new JsonSyntaxException(memberName + " must be a boolean or float");
        }
        throw new JsonSyntaxException("Missing " + memberName + ", expected to find a boolean or float");
    }

    public static float getAsBooleanFloat(JsonObject json, String memberName, float fallback) {
        return json.has(memberName) ? GsonUtil.getAsBooleanFloat(json, memberName) : fallback;
    }

    public static void ifHasKey(JsonObject json, String memberName, Consumer<JsonElement> consumer) {
        if (GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            consumer.accept(json.get(memberName));
        }
    }

    public static void ifHasObject(JsonObject json, String memberName, Consumer<JsonObject> consumer) {
        if (GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            consumer.accept(GsonHelper.m_13930_((JsonObject)json, (String)memberName));
        }
    }

    public static void ifHasArray(JsonObject json, String memberName, Consumer<JsonElement> consumer) {
        if (GsonHelper.m_13900_((JsonObject)json, (String)memberName)) {
            JsonArray array = GsonHelper.m_13933_((JsonObject)json, (String)memberName);
            for (JsonElement jsonElement : array) {
                consumer.accept(jsonElement);
            }
        }
    }

    public static JsonObject merge(JsonObject json1, JsonObject json2) {
        JsonObject json = GsonHelper.m_13864_((String)json1.toString());
        json2.entrySet().forEach(entry -> {
            if (!json.has((String)entry.getKey())) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            } else if (json.get((String)entry.getKey()).isJsonPrimitive() && ((JsonElement)entry.getValue()).isJsonPrimitive()) {
                json.add((String)entry.getKey(), (JsonElement)entry.getValue());
            } else if (json.get((String)entry.getKey()).isJsonArray() && ((JsonElement)entry.getValue()).isJsonArray()) {
                JsonArray jsonArray = json.get((String)entry.getKey()).getAsJsonArray();
                JsonArray json2Array = ((JsonElement)entry.getValue()).getAsJsonArray();
                for (int i = 0; i < json2Array.size(); ++i) {
                    jsonArray.add(json2Array.get(i));
                }
                json.add((String)entry.getKey(), (JsonElement)jsonArray);
            } else if (json.get((String)entry.getKey()).isJsonObject() && ((JsonElement)entry.getValue()).isJsonObject()) {
                json.add((String)entry.getKey(), (JsonElement)GsonUtil.merge(json.get((String)entry.getKey()).getAsJsonObject(), ((JsonElement)entry.getValue()).getAsJsonObject()));
            }
        });
        return json;
    }

    public static JsonElement nbtToJson(Tag nbt) {
        if (nbt instanceof NumericTag) {
            return new JsonPrimitive(((NumericTag)nbt).m_8103_());
        }
        if (nbt instanceof CollectionTag) {
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < ((CollectionTag)nbt).size(); ++i) {
                jsonArray.add(GsonUtil.nbtToJson((Tag)((CollectionTag)nbt).get(i)));
            }
            return jsonArray;
        }
        if (nbt instanceof StringTag) {
            return new JsonPrimitive(nbt.m_7916_());
        }
        if (nbt instanceof CompoundTag) {
            JsonObject jsonObject = new JsonObject();
            for (String key : ((CompoundTag)nbt).m_128431_()) {
                jsonObject.add(key, GsonUtil.nbtToJson(((CompoundTag)nbt).m_128423_(key)));
            }
            return jsonObject;
        }
        return new JsonObject();
    }

    public static JsonObject serializeItemStack(ItemStack stack) {
        return GsonUtil.serializeItemStack(stack, true);
    }

    public static JsonObject serializeItemStack(ItemStack stack, boolean writeNbt) {
        JsonObject json = new JsonObject();
        json.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString());
        json.addProperty("count", (Number)stack.m_41613_());
        if (writeNbt && stack.m_41782_()) {
            json.add("nbt", GsonUtil.nbtToJson((Tag)stack.m_41783_()));
        }
        return json;
    }

    public static ItemStack readItemStack(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            ResourceLocation id = new ResourceLocation(jsonElement.getAsString());
            if (!BuiltInRegistries.f_257033_.m_7804_(id)) {
                throw new JsonParseException("Unknown item '" + String.valueOf(id) + "'");
            }
            return new ItemStack((ItemLike)BuiltInRegistries.f_257033_.m_7745_(id));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject json = jsonElement.getAsJsonObject();
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"item"));
            if (!BuiltInRegistries.f_257033_.m_7804_(id)) {
                throw new JsonParseException("Unknown item '" + String.valueOf(id) + "'");
            }
            Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(id);
            return new ItemStack((ItemLike)item, GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
        }
        throw new JsonParseException("Item stack definition must either be a primitive or an object");
    }

    public static void forEachInListOrPrimitive(JsonElement element, Consumer<JsonElement> consumer) {
        if (element.isJsonPrimitive() || element.isJsonObject()) {
            consumer.accept(element);
        } else if (element.isJsonArray()) {
            JsonArray array = element.getAsJsonArray();
            for (JsonElement child : array) {
                consumer.accept(child);
            }
        }
    }

    public static <T> List<T> fromListOrPrimitive(JsonElement element, Function<JsonElement, T> function) {
        if (element.isJsonPrimitive() || element.isJsonObject()) {
            return Collections.singletonList(function.apply(element));
        }
        if (element.isJsonArray()) {
            ArrayList<T> list = new ArrayList<T>();
            JsonArray array = element.getAsJsonArray();
            for (JsonElement child : array) {
                list.add(function.apply(child));
            }
            return list;
        }
        return Collections.emptyList();
    }

    public static <T> List<T> fromListOrPrimitive(JsonElement element, Function<JsonElement, T> function, @Nullable List<T> fallback) {
        if (element == null) {
            return fallback;
        }
        return GsonUtil.fromListOrPrimitive(element, function);
    }
}

