/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.threetag.palladium.entity.BodyPart;
import net.threetag.palladium.util.property.PalladiumProperty;

public class BodyPartListProperty
extends PalladiumProperty<List<BodyPart>> {
    public BodyPartListProperty(String key) {
        super(key);
    }

    @Override
    public List<BodyPart> fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            String name = jsonElement.getAsString();
            if (name.equalsIgnoreCase("all")) {
                return Arrays.asList(BodyPart.values());
            }
            return Collections.singletonList(BodyPart.fromJson(name));
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<BodyPart> list = new ArrayList<BodyPart>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            list.add(BodyPart.fromJson(jsonArray.get(i).getAsString()));
        }
        return list;
    }

    @Override
    public JsonElement toJSON(List<BodyPart> value) {
        if (value.size() == 1) {
            return new JsonPrimitive(value.get(0).getName());
        }
        JsonArray jsonArray = new JsonArray();
        for (BodyPart bodyPart : value) {
            jsonArray.add((JsonElement)new JsonPrimitive(bodyPart.getName()));
        }
        return jsonArray;
    }

    @Override
    public List<BodyPart> fromNBT(Tag tag, List<BodyPart> defaultValue) {
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            ArrayList<BodyPart> list = new ArrayList<BodyPart>();
            for (int i = 0; i < listTag.size(); ++i) {
                list.add(BodyPart.byName(listTag.m_128778_(i)));
            }
            return list;
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(List<BodyPart> value) {
        ListTag listTag = new ListTag();
        for (BodyPart part : value) {
            listTag.add((Object)StringTag.m_129297_((String)part.getName()));
        }
        return listTag;
    }

    @Override
    public List<BodyPart> fromBuffer(FriendlyByteBuf buf) {
        int amount = buf.readInt();
        ArrayList<BodyPart> list = new ArrayList<BodyPart>();
        for (int i = 0; i < amount; ++i) {
            list.add(BodyPart.byName(buf.m_130277_()));
        }
        return list;
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        List list = (List)value;
        buf.writeInt(list.size());
        for (BodyPart part : list) {
            buf.m_130070_(part.getName());
        }
    }

    @Override
    public String getString(List<BodyPart> value) {
        return Arrays.toString(value.stream().map(BodyPart::getName).toArray());
    }
}

