/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.commands.CommandFunction;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.Palladium;
import net.threetag.palladium.addonpack.log.AddonPackLog;
import net.threetag.palladium.util.property.PalladiumProperty;

public class CommandFunctionProperty
extends PalladiumProperty<CommandFunctionParsing> {
    public CommandFunctionProperty(String key) {
        super(key);
    }

    @Override
    public CommandFunctionParsing fromJSON(JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new CommandFunctionParsing(this.fixCmd(jsonElement.getAsString()));
        }
        JsonArray jsonArray = jsonElement.getAsJsonArray();
        ArrayList<String> lines = new ArrayList<String>();
        for (int i = 0; i < jsonArray.size(); ++i) {
            lines.add(this.fixCmd(jsonArray.get(i).getAsString()));
        }
        return new CommandFunctionParsing(lines);
    }

    private String fixCmd(String cmd) {
        while (cmd.startsWith("/")) {
            cmd = cmd.substring(1);
        }
        return cmd;
    }

    @Override
    public JsonElement toJSON(CommandFunctionParsing value) {
        JsonArray array = new JsonArray();
        for (String line : value.getLines()) {
            array.add(line);
        }
        return array;
    }

    @Override
    public CommandFunctionParsing fromNBT(Tag tag, CommandFunctionParsing defaultValue) {
        if (tag instanceof ListTag) {
            ListTag listTag = (ListTag)tag;
            ArrayList<String> lines = new ArrayList<String>();
            for (int i = 0; i < listTag.size(); ++i) {
                lines.add(listTag.m_128778_(i));
            }
            return new CommandFunctionParsing(lines);
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(CommandFunctionParsing value) {
        ListTag listTag = new ListTag();
        for (String s : value.getLines()) {
            listTag.add((Object)StringTag.m_129297_((String)s));
        }
        return listTag;
    }

    @Override
    public CommandFunctionParsing fromBuffer(FriendlyByteBuf buf) {
        return new CommandFunctionParsing(buf.m_236845_(FriendlyByteBuf::m_130277_));
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.m_236828_(((CommandFunctionParsing)value).getLines(), FriendlyByteBuf::m_130070_);
    }

    @Override
    public String getString(CommandFunctionParsing value) {
        return value == null ? null : Arrays.toString(value.getLines().toArray());
    }

    public static class CommandFunctionParsing {
        private final List<String> lines;
        private CommandFunction commandFunction;
        private boolean error = false;

        public CommandFunctionParsing(List<String> lines) {
            this.lines = lines;
        }

        public CommandFunctionParsing(String line) {
            this.lines = Collections.singletonList(line);
        }

        public CommandFunction getCommandFunction(MinecraftServer server) {
            if (this.error) {
                return null;
            }
            if (this.commandFunction == null) {
                try {
                    CommandSourceStack commandSourceStack = new CommandSourceStack(CommandSource.f_80164_, Vec3.f_82478_, Vec2.f_82462_, null, 2, "", CommonComponents.f_237098_, server, null);
                    this.commandFunction = CommandFunction.m_77984_((ResourceLocation)Palladium.id("parsed"), (CommandDispatcher)server.m_129892_().m_82094_(), (CommandSourceStack)commandSourceStack, this.lines);
                }
                catch (Exception e) {
                    AddonPackLog.error(e.getMessage(), new Object[0]);
                    this.error = true;
                }
            }
            return this.commandFunction;
        }

        public List<String> getLines() {
            return this.lines;
        }
    }
}

