/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.threetag.palladium.util.property.PalladiumProperty;

public class FloatProperty
extends PalladiumProperty<Float> {
    public FloatProperty(String key) {
        super(key);
    }

    @Override
    public Float fromJSON(JsonElement jsonElement) {
        return Float.valueOf(jsonElement.getAsFloat());
    }

    @Override
    public JsonElement toJSON(Float value) {
        return new JsonPrimitive((Number)value);
    }

    @Override
    public Float fromNBT(Tag tag, Float defaultValue) {
        if (tag instanceof FloatTag) {
            FloatTag floatTag = (FloatTag)tag;
            return Float.valueOf(floatTag.m_7057_());
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(Float value) {
        return FloatTag.m_128566_((float)value.floatValue());
    }

    @Override
    public Float fromBuffer(FriendlyByteBuf buf) {
        return Float.valueOf(buf.readFloat());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.writeFloat(((Float)value).floatValue());
    }

    @Override
    public String getPropertyType() {
        return "float";
    }
}

