/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import net.minecraft.core.Registry;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.threetag.palladium.util.RegistrySynonymsHandler;
import net.threetag.palladium.util.property.PalladiumProperty;

public class RegistryObjectProperty<T>
extends PalladiumProperty<T> {
    private final Registry<T> registry;

    public RegistryObjectProperty(String key, Registry<T> registry) {
        super(key);
        this.registry = registry;
    }

    @Override
    public T fromJSON(JsonElement jsonElement) {
        ResourceLocation id = RegistrySynonymsHandler.getReplacement(this.registry, new ResourceLocation(jsonElement.getAsString()));
        if (this.registry.m_7804_(id)) {
            return (T)this.registry.m_7745_(id);
        }
        throw new JsonParseException("Unknown " + String.valueOf(this.registry.m_123023_().m_135782_()) + " '" + String.valueOf(id) + "'");
    }

    @Override
    public JsonElement toJSON(T value) {
        return new JsonPrimitive(Objects.requireNonNull(this.registry.m_7981_(value)).toString());
    }

    @Override
    public T fromNBT(Tag tag, T defaultValue) {
        StringTag stringTag;
        ResourceLocation id;
        if (tag instanceof StringTag && this.registry.m_7804_(id = RegistrySynonymsHandler.getReplacement(this.registry, new ResourceLocation((stringTag = (StringTag)tag).m_7916_())))) {
            return (T)this.registry.m_7745_(id);
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(T value) {
        return StringTag.m_129297_((String)Objects.requireNonNull(this.registry.m_7981_(value)).toString());
    }

    @Override
    public T fromBuffer(FriendlyByteBuf buf) {
        return (T)this.registry.m_7745_(buf.m_130281_());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        buf.m_130085_(this.registry.m_7981_(value));
    }

    @Override
    public String getString(T value) {
        return value != null ? Objects.requireNonNull(this.registry.m_7981_(value)).toString() : null;
    }
}

