/*
 * Decompiled with CFR 0.152.
 */
package net.threetag.palladium.util.property;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.threetag.palladium.util.property.PalladiumProperty;

public class Vec3Property
extends PalladiumProperty<Vec3> {
    public Vec3Property(String key) {
        super(key);
    }

    @Override
    public Vec3 fromJSON(JsonElement jsonElement) {
        JsonArray array = jsonElement.getAsJsonArray();
        if (array.size() != 3) {
            throw new JsonParseException(this.getKey() + " must be an array with three float");
        }
        return new Vec3(array.get(0).getAsDouble(), array.get(1).getAsDouble(), array.get(2).getAsDouble());
    }

    @Override
    public JsonElement toJSON(Vec3 value) {
        JsonArray array = new JsonArray();
        array.add((Number)value.f_82479_);
        array.add((Number)value.f_82480_);
        array.add((Number)value.f_82481_);
        return array;
    }

    @Override
    public Vec3 fromNBT(Tag tag, Vec3 defaultValue) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return new Vec3(compoundTag.m_128459_("X"), compoundTag.m_128459_("Y"), compoundTag.m_128459_("Z"));
        }
        return defaultValue;
    }

    @Override
    public Tag toNBT(Vec3 value) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.m_128347_("X", value.f_82479_);
        compoundTag.m_128347_("Y", value.f_82480_);
        compoundTag.m_128347_("Z", value.f_82481_);
        return compoundTag;
    }

    @Override
    public Vec3 fromBuffer(FriendlyByteBuf buf) {
        return new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
    }

    @Override
    public void toBuffer(FriendlyByteBuf buf, Object value) {
        Vec3 vec = (Vec3)value;
        buf.writeDouble(vec.f_82479_);
        buf.writeDouble(vec.f_82480_);
        buf.writeDouble(vec.f_82481_);
    }

    @Override
    public String getString(Vec3 value) {
        return value != null ? "[" + value.f_82479_ + " / " + value.f_82480_ + " / " + value.f_82481_ + "]" : null;
    }
}

